/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.PropagationErrorPanel;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.client.ui.commons.status.ConnObjectWrapper;
import org.apache.syncope.client.ui.commons.status.Status;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Panel {
    private static final long serialVersionUID = -4013796607157549641L;
    protected static final Logger LOG = LoggerFactory.getLogger(StatusPanel.class);
    protected Map<String, StatusBean> initialStatusBeanMap;
    protected ListViewPanel<?> listViewPanel;

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, PageReference pageRef) {
        super(id);
        this.init(any, model, SyncopeWebApplication.get().getStatusProvider().get(any, any.getResources()), pageRef, false);
    }

    public <T extends AnyTO> StatusPanel(String id, T any, IModel<List<StatusBean>> model, List<StatusProvider.InfoWithFailure> connObjects, PageReference pageRef) {
        super(id);
        this.init(any, model, connObjects, pageRef, true);
    }

    protected void init(AnyTO any, IModel<List<StatusBean>> model, final List<StatusProvider.InfoWithFailure> connObjects, PageReference pageRef, boolean enableConnObjectLink) {
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(connObjects.size() + 1);
        this.initialStatusBeanMap = new LinkedHashMap<String, StatusBean>(connObjects.size() + 1);
        StatusBean syncope = new StatusBean(any, "syncope");
        if (any instanceof UserTO) {
            UserTO userTO = (UserTO)any;
            syncope.setConnObjectLink(userTO.getUsername());
            Status syncopeStatus = Status.UNDEFINED;
            if (userTO.getStatus() != null) {
                try {
                    syncopeStatus = Status.valueOf((String)((UserTO)any).getStatus().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unexpected status found: {}", (Object)((UserTO)any).getStatus(), (Object)e);
                }
            }
            syncope.setStatus(syncopeStatus);
        } else if (any instanceof GroupTO) {
            GroupTO groupTO = (GroupTO)any;
            syncope.setConnObjectLink(groupTO.getName());
            syncope.setStatus(Status.ACTIVE);
        }
        statusBeans.add(syncope);
        this.initialStatusBeanMap.put(syncope.getResource(), syncope);
        final HashMap failureReasons = new HashMap();
        connObjects.forEach(triple -> {
            ConnObjectWrapper connObjectWrapper = triple.onResource();
            StatusBean statusBean = StatusUtils.getStatusBean((AnyTO)connObjectWrapper.getAny(), (String)connObjectWrapper.getResource(), (ConnObject)connObjectWrapper.getConnObjectTO(), (boolean)(any instanceof GroupTO));
            this.initialStatusBeanMap.put(connObjectWrapper.getResource(), statusBean);
            statusBeans.add(statusBean);
            if (StringUtils.isNotBlank((CharSequence)triple.failure())) {
                failureReasons.put(connObjectWrapper.getResource(), triple.failure());
            }
        });
        final MultilevelPanel mlp = new MultilevelPanel("resources");
        this.add(new Component[]{mlp});
        ListViewPanel.Builder<StatusBean> builder = new ListViewPanel.Builder<StatusBean>(StatusBean.class, pageRef){
            private static final long serialVersionUID = -6809736686861678498L;

            @Override
            protected Component getValueComponent(String key, StatusBean bean) {
                if ("status".equalsIgnoreCase(key)) {
                    return StatusUtils.getStatusImagePanel((String)"field", (Status)bean.getStatus());
                }
                return super.getValueComponent(key, bean);
            }
        };
        builder.setModel(model);
        builder.setItems(statusBeans);
        builder.includes("resource", "connObjectLink", "status");
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.setReuseItem(false);
        ActionLink<StatusBean> connObjectLink = new ActionLink<StatusBean>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ StatusPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected boolean statusCondition(StatusBean bean) {
                StatusProvider.Info info = StatusPanel.getStatusProviderInfo(bean.getKey(), bean.getResource(), connObjects);
                return info != null && info.onResource() != null;
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                mlp.next(bean.getResource(), new RemoteAnyPanel(bean, connObjects), target);
            }
        };
        if (!enableConnObjectLink) {
            connObjectLink.disable();
        }
        SyncopeWebApplication.get().getStatusProvider().addConnObjectLink(builder, connObjectLink);
        builder.addAction(new ActionLink<StatusBean>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ StatusPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected boolean statusCondition(StatusBean bean) {
                return failureReasons.containsKey(bean.getResource());
            }

            @Override
            public void onClick(AjaxRequestTarget target, StatusBean bean) {
                mlp.next(bean.getResource(), new PropagationErrorPanel((String)failureReasons.get(bean.getResource())), target);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "");
        this.listViewPanel = (ListViewPanel)((Object)ListViewPanel.class.cast((Object)builder.build("first")));
        mlp.setFirstLevel((Panel)this.listViewPanel);
    }

    public void setCheckAvailability(ListViewPanel.CheckAvailability check) {
        this.listViewPanel.setCheckAvailability(check);
    }

    public Map<String, StatusBean> getInitialStatusBeanMap() {
        return this.initialStatusBeanMap;
    }

    protected static StatusProvider.Info getStatusProviderInfo(String anyKey, String resource, List<StatusProvider.InfoWithFailure> objects) {
        for (StatusProvider.InfoWithFailure object : objects) {
            if (!anyKey.equals(object.onResource().getAny().getKey()) || !resource.equalsIgnoreCase(object.onResource().getResource())) continue;
            return new StatusProvider.Info(object.onSyncope(), object.onResource().getConnObjectTO());
        }
        return null;
    }

    static class RemoteAnyPanel
    extends RemoteObjectPanel {
        private static final long serialVersionUID = 4303365227411467563L;
        protected final StatusBean bean;
        protected final List<StatusProvider.InfoWithFailure> connObjects;

        RemoteAnyPanel(StatusBean bean, List<StatusProvider.InfoWithFailure> connObjects) {
            this.bean = bean;
            this.connObjects = connObjects;
            this.add(new Component[]{new ConnObjectPanel("remoteObject", Pair.of((Object)new ResourceModel("before"), (Object)new ResourceModel("after")), this.getStatusProviderInfo(), false)});
        }

        @Override
        protected final StatusProvider.Info getStatusProviderInfo() {
            return StatusPanel.getStatusProviderInfo(this.bean.getKey(), this.bean.getResource(), this.connObjects);
        }
    }
}

