/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.yubico.core.RegistrationStorage;
import com.yubico.data.CredentialRegistration;
import com.yubico.internal.util.JacksonCodecs;
import com.yubico.webauthn.attestation.Attestation;
import com.yubico.webauthn.data.ByteArray;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.device.MultifactorAuthenticationDeviceManager;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.function.FunctionUtils;
import org.springframework.beans.factory.ObjectProvider;

public class WebAuthnMultifactorAuthenticationDeviceManager
implements MultifactorAuthenticationDeviceManager {
    private static final ObjectWriter OBJECT_WRITER = JacksonCodecs.json().writerWithDefaultPrettyPrinter();
    private final RegistrationStorage webAuthnCredentialRepository;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;

    public List<MultifactorAuthenticationRegisteredDevice> findRegisteredDevices(Principal principal) {
        Collection<CredentialRegistration> registrations = this.webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId());
        return registrations.stream().filter(Objects::nonNull).map(this::mapWebAuthnAccount).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void removeRegisteredDevice(Principal principal, String deviceId) {
        FunctionUtils.doAndHandle(__ -> {
            ByteArray credentialId = ByteArray.fromBase64Url((String)deviceId);
            this.webAuthnCredentialRepository.removeRegistrationByUsernameAndCredentialId(principal.getId(), credentialId);
        });
    }

    public List<String> getSource() {
        return List.of("Web Authn");
    }

    protected MultifactorAuthenticationRegisteredDevice mapWebAuthnAccount(CredentialRegistration acct) {
        Attestation attestation = Optional.ofNullable(acct.getAttestationMetadata()).orElseGet(Attestation::empty);
        Map vendor = attestation.getVendorProperties().orElseGet(Map::of);
        Map device = attestation.getDeviceProperties().orElseGet(Map::of);
        return (MultifactorAuthenticationRegisteredDevice)FunctionUtils.doUnchecked(() -> MultifactorAuthenticationRegisteredDevice.builder().id(acct.getCredential().getCredentialId().getBase64Url()).name(acct.getCredentialNickname()).type((String)vendor.get("name")).model((String)device.get("displayName")).lastUsedDateTime(acct.getRegistrationTime().toString()).payload(OBJECT_WRITER.writeValueAsString((Object)acct)).source(this.getSource().getFirst()).details(Map.of("providerId", ((MultifactorAuthenticationProvider)this.multifactorAuthenticationProvider.getObject()).getId())).build());
    }

    @Generated
    public WebAuthnMultifactorAuthenticationDeviceManager(RegistrationStorage webAuthnCredentialRepository, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
    }
}

