/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web;

import com.yubico.core.WebAuthnServer;
import com.yubico.data.AssertionRequestWrapper;
import com.yubico.data.RegistrationRequest;
import com.yubico.util.Either;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ResidentKeyRequirement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.webauthn.web.BaseWebAuthnController;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/webauthn"})
@ResponseBody
@Tag(name="WebAuthN")
public class WebAuthnController
extends BaseWebAuthnController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnController.class);
    public static final String WEBAUTHN_ENDPOINT_REGISTER = "/register";
    public static final String WEBAUTHN_ENDPOINT_AUTHENTICATE = "/authenticate";
    private static final String WEBAUTHN_ENDPOINT_FINISH = "/finish";
    private final WebAuthnServer server;

    private static ResponseEntity<Object> startResponse(Object request) throws Exception {
        String json = WebAuthnController.writeJson(request);
        LOGGER.trace("Start: [{}]", (Object)json);
        return ResponseEntity.ok((Object)json);
    }

    private static ResponseEntity<Object> finishResponse(Either<List<String>, ?> result, String responseJson) throws Exception {
        if (result.isRight()) {
            LOGGER.trace("Received: [{}]", (Object)responseJson);
            String json = WebAuthnController.writeJson(result.right().orElseThrow());
            LOGGER.trace("Returned: [{}]", (Object)json);
            return ResponseEntity.ok((Object)json);
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), result.left().orElseThrow());
    }

    private static ResponseEntity<Object> messagesJson(ResponseEntity.BodyBuilder response, String message) {
        return WebAuthnController.messagesJson(response, List.of(message));
    }

    private static ResponseEntity<Object> messagesJson(ResponseEntity.BodyBuilder response, List<String> messages) {
        return response.body(Map.of("messages", messages));
    }

    @PostMapping(value={"/register"}, produces={"application/json"})
    @Operation(summary="Start registration", parameters={@Parameter(name="displayName", in=ParameterIn.QUERY, required=true, description="Display name"), @Parameter(name="credentialNickname", in=ParameterIn.QUERY, required=false, description="Credential nickname"), @Parameter(name="requireResidentKey", in=ParameterIn.QUERY, required=false, description="Require resident key"), @Parameter(name="sessionToken", in=ParameterIn.QUERY, required=false, description="Session token")}, requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(required=true, description="RegistrationRequest JSON payload", content={@Content(mediaType="application/json", schema=@Schema(implementation=RegistrationRequest.class))}))
    public ResponseEntity<Object> startRegistration(@RequestParam(value="displayName") @NonNull String displayName, @RequestParam(value="credentialNickname", required=false, defaultValue="") String credentialNickname, @RequestParam(value="requireResidentKey", required=false) boolean requireResidentKey, @RequestParam(value="sessionToken", required=false, defaultValue="") String sessionTokenBase64, Principal authenticatedPrincipal, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        Either<String, RegistrationRequest> result = this.server.startRegistration(request, authenticatedPrincipal.getName(), Optional.of(displayName), Optional.ofNullable(credentialNickname), requireResidentKey ? ResidentKeyRequirement.REQUIRED : ResidentKeyRequirement.DISCOURAGED, Optional.ofNullable(sessionTokenBase64).map(Unchecked.function(ByteArray::fromBase64Url)));
        if (result.isRight()) {
            return WebAuthnController.startResponse(new StartRegistrationResponse(result.right().orElseThrow()));
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), result.left().orElseThrow());
    }

    @PostMapping(value={"/register/finish"}, produces={"application/json"})
    @Operation(summary="Finish registration")
    public ResponseEntity<Object> finishRegistration(HttpServletRequest request, @RequestBody String responseJson) throws Exception {
        Either<List<String>, WebAuthnServer.SuccessfulRegistrationResult> result = this.server.finishRegistration(request, responseJson);
        return WebAuthnController.finishResponse(result, responseJson);
    }

    @PostMapping(value={"/authenticate"}, produces={"application/json"})
    @Operation(summary="Start authentication")
    public ResponseEntity<Object> startAuthentication(HttpServletRequest request, Principal authenticatedPrincipal) throws Exception {
        Either<List<String>, AssertionRequestWrapper> result = this.server.startAuthentication(request, Optional.ofNullable(authenticatedPrincipal).map(Principal::getName));
        if (result.isRight()) {
            return WebAuthnController.startResponse(new StartAuthenticationResponse(result.right().orElseThrow()));
        }
        return WebAuthnController.messagesJson(ResponseEntity.badRequest(), result.left().orElseThrow());
    }

    @PostMapping(value={"/authenticate/finish"}, produces={"application/json"})
    @Operation(summary="Finish authentication")
    public ResponseEntity<Object> finishAuthentication(HttpServletRequest request, @RequestBody String responseJson) throws Exception {
        Either<List<String>, WebAuthnServer.SuccessfulAuthenticationResult> result = this.server.finishAuthentication(request, responseJson);
        return WebAuthnController.finishResponse(result, responseJson);
    }

    @Generated
    public WebAuthnController(WebAuthnServer server) {
        this.server = server;
    }

    private static final class StartRegistrationResponse {
        private final boolean success = true;
        private final RegistrationRequest request;
        private final StartRegistrationActions actions = new StartRegistrationActions();

        @Generated
        public StartRegistrationResponse(RegistrationRequest request) {
            this.request = request;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public RegistrationRequest getRequest() {
            return this.request;
        }

        @Generated
        public StartRegistrationActions getActions() {
            return this.actions;
        }
    }

    private static final class StartAuthenticationResponse {
        private final boolean success = true;
        private final AssertionRequestWrapper request;
        private final StartAuthenticationActions actions = new StartAuthenticationActions();

        @Generated
        public StartAuthenticationResponse(AssertionRequestWrapper request) {
            this.request = request;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public AssertionRequestWrapper getRequest() {
            return this.request;
        }

        @Generated
        public StartAuthenticationActions getActions() {
            return this.actions;
        }
    }

    private static final class StartAuthenticationActions {
        private final String finish = "/webauthn/authenticate/finish";

        private StartAuthenticationActions() {
        }

        @Generated
        public String getFinish() {
            return this.finish;
        }
    }

    private static final class StartRegistrationActions {
        private final String finish = "/webauthn/register/finish";

        private StartRegistrationActions() {
        }

        @Generated
        public String getFinish() {
            return this.finish;
        }
    }
}

