/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantDelegatedAuthenticationPolicy;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.jooq.lambda.Unchecked;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDelegatedIdentityProviders
implements DelegatedIdentityProviders {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedIdentityProviders.class);
    protected final DelegatedIdentityProviderFactory delegatedIdentityProviderFactory;
    protected final TenantExtractor tenantExtractor;

    public List<? extends Client> findAllClients(Service service, WebContext webContext) {
        Optional tenant = this.tenantExtractor.extract(webContext.getRequestURL());
        if (tenant.isPresent()) {
            TenantDefinition definition = (TenantDefinition)tenant.get();
            String tenantKey = this.tenantExtractor.getTenantKey(definition);
            List providers = this.delegatedIdentityProviderFactory.retrieve(tenantKey);
            if (providers.isEmpty()) {
                providers = Optional.of(definition.bindProperties()).filter(bindingContext -> bindingContext.containsBindingFor(Pac4jDelegatedAuthenticationProperties.class)).map(ConfigurationPropertiesBindingContext::value).map(Unchecked.function(arg_0 -> ((DelegatedIdentityProviderFactory)this.delegatedIdentityProviderFactory).buildFrom(arg_0))).stream().flatMap(Collection::stream).collect(Collectors.toList());
                TenantDelegatedAuthenticationPolicy policy = definition.getDelegatedAuthenticationPolicy();
                if (policy != null && !policy.getAllowedProviders().isEmpty()) {
                    ArrayList<BaseClient> builtProviders = new ArrayList<BaseClient>(this.delegatedIdentityProviderFactory.build());
                    builtProviders.removeIf(client -> !policy.getAllowedProviders().contains(client.getName()));
                    providers.addAll(builtProviders);
                }
                this.delegatedIdentityProviderFactory.store(tenantKey, providers);
            }
            return providers;
        }
        List providers = this.delegatedIdentityProviderFactory.build();
        LOGGER.trace("The following clients are built: [{}]", (Object)providers);
        return new ArrayList(providers);
    }

    @Generated
    public DefaultDelegatedIdentityProviders(DelegatedIdentityProviderFactory delegatedIdentityProviderFactory, TenantExtractor tenantExtractor) {
        this.delegatedIdentityProviderFactory = delegatedIdentityProviderFactory;
        this.tenantExtractor = tenantExtractor;
    }
}

