/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;

@Schema(allOf={AnyTO.class})
public class UserTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 7791304495192615740L;
    private String password;
    private String token;
    private OffsetDateTime tokenExpireTime;
    private String username;
    private OffsetDateTime lastLoginDate;
    private OffsetDateTime changePwdDate;
    private Integer failedLogins;
    private String securityQuestion;
    private String securityAnswer;
    private boolean suspended;
    private boolean mustChangePassword;
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<String> roles = new ArrayList<String>();
    private final List<String> dynRoles = new ArrayList<String>();
    private final List<LinkedAccountTO> linkedAccounts = new ArrayList<LinkedAccountTO>();
    private final List<String> delegatingDelegations = new ArrayList<String>();
    private final List<String> delegatedDelegations = new ArrayList<String>();

    @Override
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.to.UserTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @Override
    public String getType() {
        return AnyTypeKind.USER.name();
    }

    @Override
    public void setType(String type) {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public OffsetDateTime getTokenExpireTime() {
        return this.tokenExpireTime;
    }

    public void setTokenExpireTime(OffsetDateTime tokenExpireTime) {
        this.tokenExpireTime = tokenExpireTime;
    }

    @JsonProperty(required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public OffsetDateTime getChangePwdDate() {
        return this.changePwdDate;
    }

    public Integer getFailedLogins() {
        return this.failedLogins;
    }

    public OffsetDateTime getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setChangePwdDate(OffsetDateTime changePwdDate) {
        this.changePwdDate = changePwdDate;
    }

    public void setFailedLogins(Integer failedLogins) {
        this.failedLogins = failedLogins;
    }

    public void setLastLoginDate(OffsetDateTime lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getDynRoles() {
        return this.dynRoles;
    }

    public List<LinkedAccountTO> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public List<String> getDelegatingDelegations() {
        return this.delegatingDelegations;
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public List<String> getDelegatedDelegations() {
        return this.delegatedDelegations;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.username).append(this.roles).append(this.dynRoles).append((Object)this.token).append((Object)this.tokenExpireTime).append((Object)this.lastLoginDate).append((Object)this.changePwdDate).append((Object)this.failedLogins).append((Object)this.securityQuestion).append((Object)this.securityAnswer).append(this.suspended).append(this.mustChangePassword).append(this.memberships).append(this.linkedAccounts).append(this.delegatingDelegations).append(this.delegatedDelegations).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTO other = (UserTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.username, (Object)other.username).append(this.roles, other.roles).append(this.dynRoles, other.dynRoles).append((Object)this.token, (Object)other.token).append((Object)this.tokenExpireTime, (Object)other.tokenExpireTime).append((Object)this.lastLoginDate, (Object)other.lastLoginDate).append((Object)this.changePwdDate, (Object)other.changePwdDate).append((Object)this.failedLogins, (Object)other.failedLogins).append((Object)this.securityQuestion, (Object)other.securityQuestion).append((Object)this.securityAnswer, (Object)other.securityAnswer).append(this.suspended, other.suspended).append(this.mustChangePassword, other.mustChangePassword).append(this.memberships, other.memberships).append(this.linkedAccounts, other.linkedAccounts).append(this.delegatingDelegations, other.delegatingDelegations).append(this.delegatedDelegations, other.delegatedDelegations).build();
    }
}

