/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.Executor;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class ErrorHandlingTaskExecutor
implements TaskExecutor {
    private static final ObservationRegistry FOR_SCOPES = ObservationRegistry.create();
    private final Executor executor;
    private final ErrorHandler errorHandler;

    public ErrorHandlingTaskExecutor(Executor executor, ErrorHandler errorHandler) {
        Assert.notNull((Object)executor, (String)"executor must not be null");
        Assert.notNull((Object)errorHandler, (String)"errorHandler must not be null");
        this.executor = executor;
        this.errorHandler = errorHandler;
    }

    public boolean isSyncExecutor() {
        return this.executor instanceof SyncTaskExecutor;
    }

    public void execute(Runnable task) {
        this.executor.execute(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                try {
                    this.errorHandler.handleError(throwable);
                }
                finally {
                    Observation.Scope currentObservationScope = FOR_SCOPES.getCurrentObservationScope();
                    if (currentObservationScope != null) {
                        currentObservationScope.close();
                        Observation currentObservation = currentObservationScope.getCurrentObservation();
                        currentObservation.error(throwable);
                        currentObservation.stop();
                    }
                }
            }
        });
    }
}

