/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.token;

import com.nimbusds.oauth2.sdk.dpop.verifiers.InvalidDPoPProofException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20AccessTokenEndpointController;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="OpenID Connect")
public class OidcAccessTokenEndpointController
extends OAuth20AccessTokenEndpointController<OidcConfigurationContext> {
    public OidcAccessTokenEndpointController(OidcConfigurationContext oauthConfigurationContext, AuditableExecution accessTokenGrantAuditableRequestExtractor) {
        super((OAuth20ConfigurationContext)oauthConfigurationContext, accessTokenGrantAuditableRequestExtractor);
    }

    @PostMapping(value={"/oidc/accessToken", "/oidc/token", "/**/oidcAccessToken", "/**/oidcToken"})
    @Operation(summary="Handle OIDC access token request")
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        OidcIssuerService issuerService = ((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService();
        if (!issuerService.validateIssuer((WebContext)webContext, List.of("accessToken", "token", "oidcAccessToken", "oidcToken"))) {
            return OAuth20Utils.writeError((HttpServletResponse)response, (String)"invalid_request", (String)"Invalid issuer");
        }
        return super.handleRequest(request, response);
    }

    @GetMapping(value={"/oidc/accessToken", "/oidc/token", "/**/oidcAccessToken", "/**/oidcToken"})
    @Operation(summary="Handle OIDC access token request")
    public ModelAndView handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }

    @ExceptionHandler(value={InvalidDPoPProofException.class})
    public ModelAndView handleInvalidDPoPProofException(HttpServletResponse req, Exception ex) {
        return OAuth20Utils.writeError((HttpServletResponse)req, (String)"invalid_dpop_proof");
    }
}

