/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.passwordless;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.api.PasswordlessAuthenticationRequest;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DefaultDelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.web.flow.PasswordlessWebflowUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.springframework.webflow.execution.RequestContext;

public class SurrogateDelegatedAuthenticationCredentialExtractor
extends DefaultDelegatedAuthenticationCredentialExtractor {
    private int order = Integer.MIN_VALUE;

    public SurrogateDelegatedAuthenticationCredentialExtractor(SessionStore sessionStore) {
        super(sessionStore);
    }

    protected Optional<ClientCredential> buildClientCredential(BaseClient client, RequestContext requestContext, Credentials credential) {
        Optional clientCredential = super.buildClientCredential(client, requestContext, credential);
        Optional<PasswordlessAuthenticationRequest> passwordlessRequestResult = Optional.ofNullable((PasswordlessAuthenticationRequest)PasswordlessWebflowUtils.getPasswordlessAuthenticationRequest((RequestContext)requestContext, PasswordlessAuthenticationRequest.class));
        if (clientCredential.isPresent() && passwordlessRequestResult.isPresent()) {
            PasswordlessAuthenticationRequest passwordlessRequest = passwordlessRequestResult.get();
            if (passwordlessRequest.getProperties().containsKey("surrogateUsername")) {
                String surrogateUsername = (String)passwordlessRequest.getProperties().get("surrogateUsername");
                ((ClientCredential)clientCredential.get()).getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateUsername));
            }
            return clientCredential;
        }
        return Optional.empty();
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

