/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.api.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.common.keymaster.client.api.model.Domain;

public class JPADomain
extends Domain {
    private static final long serialVersionUID = 18711766451769410L;
    private String jdbcDriver;
    private String jdbcURL;
    private String dbSchema;
    private String dbUsername;
    private String dbPassword;
    private TransactionIsolation transactionIsolation = TransactionIsolation.TRANSACTION_READ_COMMITTED;
    private int poolMaxActive = 10;
    private int poolMinIdle = 2;
    private String orm = "META-INF/spring-orm.xml";
    private String databasePlatform;

    @Override
    protected String defaultContentFile() {
        return "defaultContent.jpa.xml";
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public TransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getPoolMaxActive() {
        return this.poolMaxActive;
    }

    public void setPoolMaxActive(int poolMaxActive) {
        this.poolMaxActive = poolMaxActive;
    }

    public int getPoolMinIdle() {
        return this.poolMinIdle;
    }

    public void setPoolMinIdle(int poolMinIdle) {
        this.poolMinIdle = poolMinIdle;
    }

    public String getOrm() {
        return this.orm;
    }

    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.jdbcDriver).append((Object)this.jdbcURL).append((Object)this.dbSchema).append((Object)this.dbUsername).append((Object)this.dbPassword).append((Object)this.transactionIsolation).append(this.poolMaxActive).append(this.poolMinIdle).append((Object)this.orm).append((Object)this.databasePlatform).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JPADomain other = (JPADomain)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.jdbcDriver, (Object)other.jdbcDriver).append((Object)this.jdbcURL, (Object)other.jdbcURL).append((Object)this.dbSchema, (Object)other.dbSchema).append((Object)this.dbUsername, (Object)other.dbUsername).append((Object)this.dbPassword, (Object)other.dbPassword).append((Object)this.transactionIsolation, (Object)other.transactionIsolation).append(this.poolMaxActive, other.poolMaxActive).append(this.poolMinIdle, other.poolMinIdle).append((Object)this.orm, (Object)other.orm).append((Object)this.databasePlatform, (Object)other.databasePlatform).build();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append((Object)this.jdbcDriver).append((Object)this.jdbcURL).append((Object)this.dbSchema).append((Object)this.dbUsername).append((Object)this.dbPassword).append((Object)this.transactionIsolation).append(this.poolMaxActive).append(this.poolMinIdle).append((Object)this.orm).append((Object)this.databasePlatform).build();
    }

    public static enum TransactionIsolation {
        TRANSACTION_NONE,
        TRANSACTION_READ_COMMITTED,
        TRANSACTION_READ_UNCOMMITTED,
        TRANSACTION_REPEATABLE_READ,
        TRANSACTION_SERIALIZABLE;

    }

    public static class Builder
    extends Domain.Builder<JPADomain, Builder> {
        public Builder(String key) {
            super(new JPADomain(), key);
        }

        public Builder jdbcDriver(String jdbcDriver) {
            ((JPADomain)this.domain).jdbcDriver = jdbcDriver;
            return this;
        }

        public Builder jdbcURL(String jdbcURL) {
            ((JPADomain)this.domain).jdbcURL = jdbcURL;
            return this;
        }

        public Builder dbSchema(String dbSchema) {
            if (StringUtils.isNotBlank((CharSequence)dbSchema)) {
                ((JPADomain)this.domain).dbSchema = dbSchema;
            }
            return this;
        }

        public Builder dbUsername(String dbUsername) {
            ((JPADomain)this.domain).dbUsername = dbUsername;
            return this;
        }

        public Builder dbPassword(String dbPassword) {
            ((JPADomain)this.domain).dbPassword = dbPassword;
            return this;
        }

        public Builder transactionIsolation(TransactionIsolation transactionIsolation) {
            ((JPADomain)this.domain).transactionIsolation = transactionIsolation;
            return this;
        }

        public Builder poolMaxActive(int poolMaxActive) {
            ((JPADomain)this.domain).poolMaxActive = poolMaxActive;
            return this;
        }

        public Builder poolMinIdle(int poolMinIdle) {
            ((JPADomain)this.domain).poolMinIdle = poolMinIdle;
            return this;
        }

        public Builder orm(String orm) {
            ((JPADomain)this.domain).orm = orm;
            return this;
        }

        public Builder databasePlatform(String databasePlatform) {
            ((JPADomain)this.domain).databasePlatform = databasePlatform;
            return this;
        }
    }
}

