/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.pagestore;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.pagestore.StoreSettingsProperties;
import java.io.File;
import lombok.Generated;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.StoreSettings;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.pagestore", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={StoreSettingsProperties.class})
public class StoreSettingsConfig
implements WicketApplicationInitConfiguration {
    private final StoreSettingsProperties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        StoreSettings storeSettings = webApplication.getStoreSettings();
        if (this.props.getAsynchronous() != null) {
            storeSettings.setAsynchronous(this.props.getAsynchronous().booleanValue());
        }
        if (this.props.getAsynchronousQueueCapacity() != null) {
            storeSettings.setAsynchronousQueueCapacity(this.props.getAsynchronousQueueCapacity().intValue());
        }
        if (this.props.getFileStoreFolder() != null) {
            storeSettings.setFileStoreFolder(new File(this.props.getFileStoreFolder()));
        }
        storeSettings.setMaxSizePerSession(TypeParser.parse((Long)this.props.getSessionSize(), (SessionUnit)this.props.getSessionUnit()));
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public StoreSettingsConfig(StoreSettingsProperties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

