/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.hazelcast;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.extensions.types.SessionUnit;
import com.giffing.wicket.spring.boot.context.extensions.types.TypeParser;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.datastore.hazelcast.DataStoreHazelcastProperties;
import com.hazelcast.core.HazelcastInstance;
import lombok.Generated;
import org.apache.wicket.Application;
import org.apache.wicket.DefaultPageManagerProvider;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;
import org.wicketstuff.datastores.hazelcast.HazelcastDataStore;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.datastore.hazelcast", value={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnClass(value={HazelcastInstance.class, HazelcastDataStore.class})
@EnableConfigurationProperties(value={DataStoreHazelcastProperties.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class DataStoreHazelcastConfig
implements WicketApplicationInitConfiguration {
    private final DataStoreHazelcastProperties prop;
    private final HazelcastInstance hazelcastInstance;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(final WebApplication webApplication) {
        webApplication.setPageManagerProvider((IPageManagerProvider)new DefaultPageManagerProvider((Application)webApplication){

            protected IPageStore newPersistentStore() {
                HazelcastDataStore hazelcastDataStore = new HazelcastDataStore(webApplication.getName(), DataStoreHazelcastConfig.this.hazelcastInstance);
                return new SessionQuotaManagingDataStore((IPageStore)hazelcastDataStore, TypeParser.parse((Long)DataStoreHazelcastConfig.this.prop.getSessionSize(), (SessionUnit)DataStoreHazelcastConfig.this.prop.getSessionUnit()));
            }
        });
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).build());
    }

    @Generated
    public DataStoreHazelcastConfig(DataStoreHazelcastProperties prop, HazelcastInstance hazelcastInstance, WicketEndpointRepository wicketEndpointRepository) {
        this.prop = prop;
        this.hazelcastInstance = hazelcastInstance;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

