/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.foursquare;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.foursquare.FoursquareProfile;
import org.pac4j.oauth.profile.foursquare.FoursquareUserContact;
import org.pac4j.oauth.profile.foursquare.FoursquareUserFriends;
import org.pac4j.oauth.profile.foursquare.FoursquareUserPhoto;

public class FoursquareProfileDefinition
extends OAuthProfileDefinition {
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String PHOTO = "photo";
    public static final String FIRENDS = "friends";
    public static final String HOME_CITY = "homeCity";
    public static final String CONTACT = "contact";
    public static final String BIO = "bio";

    public FoursquareProfileDefinition() {
        super(x -> new FoursquareProfile());
        Arrays.stream(new String[]{FIRST_NAME, LAST_NAME, HOME_CITY, BIO, PHOTO}).forEach(a -> this.primary((String)a, Converters.STRING));
        this.primary("gender", Converters.GENDER);
        this.primary(FIRENDS, new JsonConverter(FoursquareUserFriends.class));
        this.primary(CONTACT, new JsonConverter(FoursquareUserContact.class));
        this.primary(PHOTO, new JsonConverter(FoursquareUserPhoto.class));
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        return "https://api.foursquare.com/v2/users/self?v=20131118";
    }

    @Override
    public FoursquareProfile extractUserProfile(String body) {
        JsonNode user;
        JsonNode response;
        FoursquareProfile profile = (FoursquareProfile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json == null) {
            this.raiseProfileExtractionJsonError(body);
        }
        if ((response = (JsonNode)JsonHelper.getElement(json, "response")) == null) {
            this.raiseProfileExtractionJsonError(body, "response");
        }
        if ((user = (JsonNode)JsonHelper.getElement(response, "user")) != null) {
            profile.setId(ProfileHelper.sanitizeIdentifier((Object)JsonHelper.getElement(user, "id")));
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(user, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body, "user");
        }
        return profile;
    }
}

