/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.handler.TenantAuthenticationHandlerBuilder;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.syncope.TenantSyncopeAuthenticationHandlerBuilder;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="syncope")
@Configuration(value="SyncopeAuthenticationConfiguration", proxyBeanMethods=false)
class SyncopeAuthenticationConfiguration {
    SyncopeAuthenticationConfiguration() {
    }

    @ConditionalOnMissingBean(name={"syncopePrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory syncopePrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"syncopeAuthenticationHandlers"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<AuthenticationHandler> syncopeAuthenticationHandlers(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="syncopePrincipalFactory") PrincipalFactory syncopePrincipalFactory, @Qualifier(value="syncopePasswordPolicyConfiguration") PasswordPolicyContext syncopePasswordPolicyConfiguration, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        SyncopeAuthenticationProperties syncope = casProperties.getAuthn().getSyncope();
        List<? extends AuthenticationHandler> handlers = SyncopeUtils.newAuthenticationHandlers(syncope, applicationContext, syncopePrincipalFactory, servicesManager, syncopePasswordPolicyConfiguration);
        return BeanContainer.of(handlers);
    }

    @ConditionalOnMissingBean(name={"syncopeAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer syncopeAuthenticationEventExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="syncopeAuthenticationHandlers") BeanContainer<AuthenticationHandler> syncopeAuthenticationHandlers, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
        return plan -> {
            SyncopeAuthenticationProperties syncope = casProperties.getAuthn().getSyncope();
            FunctionUtils.doIf((boolean)syncope.isDefined(), o -> syncopeAuthenticationHandlers.toList().forEach(handler -> plan.registerAuthenticationHandlerWithPrincipalResolver(handler, defaultPrincipalResolver))).accept(syncope);
        };
    }

    @ConditionalOnMissingBean(name={"syncopePasswordPolicyConfiguration"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PasswordPolicyContext syncopePasswordPolicyConfiguration() {
        return new PasswordPolicyContext();
    }

    @Configuration(value="SyncopeAuthenticationMultitenancyConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Multitenancy})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class SyncopeAuthenticationMultitenancyConfiguration {
        SyncopeAuthenticationMultitenancyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"syncopeMultitenancyAuthenticationPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer syncopeMultitenancyAuthenticationPlanConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="syncopePrincipalFactory") PrincipalFactory syncopePrincipalFactory, @Qualifier(value="syncopePasswordPolicyConfiguration") PasswordPolicyContext syncopePasswordPolicyConfiguration, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return plan -> {
                if (casProperties.getMultitenancy().getCore().isEnabled()) {
                    TenantSyncopeAuthenticationHandlerBuilder builder = new TenantSyncopeAuthenticationHandlerBuilder(syncopePasswordPolicyConfiguration, syncopePrincipalFactory, applicationContext, servicesManager);
                    plan.registerTenantAuthenticationHandlerBuilder((TenantAuthenticationHandlerBuilder)builder);
                }
            };
        }
    }
}

