/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple;

import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationFailedException;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CasSimpleMultifactorAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorAuthenticationHandler.class);
    private final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;
    private final ConfigurableApplicationContext applicationContext;

    public CasSimpleMultifactorAuthenticationHandler(CasSimpleMultifactorAuthenticationProperties properties, ConfigurableApplicationContext applicationContext, PrincipalFactory principalFactory, CasSimpleMultifactorAuthenticationService mfaService, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        super(properties.getName(), principalFactory, Integer.valueOf(properties.getOrder()));
        this.multifactorAuthenticationService = mfaService;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
        this.applicationContext = applicationContext;
    }

    public boolean supports(Credential credential) {
        return CasSimpleMultifactorTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return CasSimpleMultifactorTokenCredential.class.isAssignableFrom(clazz);
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Exception {
        return (AuthenticationHandlerExecutionResult)FunctionUtils.doAndThrow(() -> {
            Principal activePrincipal;
            CasSimpleMultifactorTokenCredential tokenCredential = (CasSimpleMultifactorTokenCredential)credential;
            Principal credentialPrincipal = this.multifactorAuthenticationService.fetch(tokenCredential);
            Principal resolvedPrincipal = this.resolvePrincipal((ApplicationContext)this.applicationContext, credentialPrincipal);
            Principal principal = this.multifactorAuthenticationService.validate(resolvedPrincipal, tokenCredential);
            if (!principal.equals((Object)(activePrincipal = this.findActivePrincipal()))) {
                LOGGER.warn("Credential principal [{}] does not match authentication principal [{}]", (Object)principal.getId(), (Object)activePrincipal.getId());
                throw new MultifactorAuthenticationFailedException("Failed to authenticate code " + tokenCredential.getId());
            }
            return this.createHandlerResult((Credential)tokenCredential, principal);
        }, MultifactorAuthenticationFailedException::new);
    }

    protected Principal findActivePrincipal() {
        Authentication authentication = Objects.requireNonNull(WebUtils.getInProgressAuthentication());
        Principal principal = authentication.getPrincipal();
        return principal.getOwner();
    }

    @Generated
    public CasSimpleMultifactorAuthenticationService getMultifactorAuthenticationService() {
        return this.multifactorAuthenticationService;
    }

    @Generated
    public ObjectProvider<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }

    @Generated
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

