/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.sms.SmsBodyBuilder;
import org.apereo.cas.notifications.sms.SmsRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorSendSms {
    private final CommunicationsManager communicationsManager;
    private final CasSimpleMultifactorAuthenticationProperties properties;

    protected boolean send(Principal principal, Ticket tokenTicket, RequestContext requestContext, List<String> recipients) {
        return (Boolean)FunctionUtils.doIf((boolean)this.communicationsManager.isSmsSenderDefined(), (Supplier)Unchecked.supplier(() -> {
            SmsProperties smsProperties = this.properties.getSms();
            String token = tokenTicket.getId();
            String tokenWithoutPrefix = token.substring("CASMFA".length() + 1);
            String smsText = this.buildTextMessageBody(smsProperties, token, tokenWithoutPrefix);
            SmsRequest smsRequest = SmsRequest.builder().from(smsProperties.getFrom()).principal(principal).to(recipients).text(smsText).tenant(this.communicationsManager.getTenantExtractor().extract(requestContext).map(TenantDefinition::getId).orElse("")).build();
            return this.communicationsManager.sms(smsRequest);
        }), () -> false).get();
    }

    protected boolean send(Principal principal, Ticket tokenTicket, RequestContext requestContext) {
        return this.send(principal, tokenTicket, requestContext, this.getSmsRecipients(requestContext, principal));
    }

    protected List<String> getSmsRecipients(RequestContext requestContext, Principal principal) {
        SmsProperties smsProperties = this.properties.getSms();
        return smsProperties.getAttributeName().stream().map(attribute -> SmsRequest.builder().from(smsProperties.getFrom()).principal(principal).tenant(this.communicationsManager.getTenantExtractor().extract(requestContext).map(TenantDefinition::getId).orElse("")).attribute(SpringExpressionLanguageValueResolver.getInstance().resolve(attribute)).build().getRecipients()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    protected String buildTextMessageBody(SmsProperties smsProperties, String token, String tokenWithoutPrefix) {
        return (String)FunctionUtils.doIfNotBlank((CharSequence)smsProperties.getText(), () -> SmsBodyBuilder.builder().properties(smsProperties).parameters(Map.of("token", token, "tokenWithoutPrefix", tokenWithoutPrefix)).build().get(), () -> token);
    }

    @Generated
    private CasSimpleMultifactorSendSms(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        this.communicationsManager = communicationsManager;
        this.properties = properties;
    }

    @Generated
    protected static CasSimpleMultifactorSendSms of(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        return new CasSimpleMultifactorSendSms(communicationsManager, properties);
    }
}

