/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.LogoutConfirmationResolver;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviders;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientSessionManager;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpointContributor;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.DelegatedAuthenticationSaml2WebflowConfigurer;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.actions.logout.DelegatedSaml2ClientFinishLogoutAction;
import org.apereo.cas.web.flow.actions.logout.DelegatedSaml2ClientLogoutAction;
import org.apereo.cas.web.flow.actions.logout.DelegatedSaml2ClientTerminateSessionAction;
import org.apereo.cas.web.saml2.DelegatedClientSaml2Builder;
import org.apereo.cas.web.saml2.DelegatedClientSaml2SessionManager;
import org.apereo.cas.web.saml2.DelegatedClientsSaml2EndpointContributor;
import org.apereo.cas.web.saml2.DelegatedSaml2ClientMetadataController;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml")
@Configuration(value="DelegatedAuthenticationSaml2Configuration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
class DelegatedAuthenticationSaml2Configuration {
    DelegatedAuthenticationSaml2Configuration() {
    }

    @Configuration(value="DelegatedAuthenticationSAMLWebConfiguration", proxyBeanMethods=false)
    static class DelegatedAuthenticationSAMLWebConfiguration {
        DelegatedAuthenticationSAMLWebConfiguration() {
        }

        @ConditionalOnMissingBean(name={"delegatedSaml2ClientTerminateSessionAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedSaml2ClientTerminateSessionAction(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="logoutConfirmationResolver") LogoutConfirmationResolver logoutConfirmationResolver, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return (Action)BeanSupplier.of(Action.class).when(BeanCondition.on((String)"cas.slo.disabled").isFalse().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedSaml2ClientTerminateSessionAction(identityProviders, delegatedClientDistributedSessionStore, logoutConfirmationResolver)).withId("delegatedSaml2ClientTerminateSessionAction").build().get()).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"delegatedSaml2ClientLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedSaml2ClientLogoutAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultSingleLogoutRequestExecutor") SingleLogoutRequestExecutor singleLogoutRequestExecutor) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedSaml2ClientLogoutAction(ticketRegistry, singleLogoutRequestExecutor)).withId("delegatedSaml2ClientLogoutAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationSaml2ClientFinishLogoutAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action delegatedAuthenticationSaml2ClientFinishLogoutAction(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutConfirmationResolver") LogoutConfirmationResolver logoutConfirmationResolver, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean configBean, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="webApplicationServiceFactory") ServiceFactory serviceFactory, @Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="delegatedClientDistributedSessionStore") SessionStore delegatedClientDistributedSessionStore) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DelegatedSaml2ClientFinishLogoutAction(identityProviders, delegatedClientDistributedSessionStore, configBean, ticketRegistry, ticketFactory, serviceFactory, logoutConfirmationResolver)).withId("delegatedAuthenticationSaml2ClientFinishLogoutAction").build().get();
        }

        @ConditionalOnMissingBean(name={"delegatedAuthenticationSaml2WebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer delegatedAuthenticationSaml2WebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new DelegatedAuthenticationSaml2WebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedAuthenticationSaml2WebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer delegatedAuthenticationSaml2WebflowExecutionPlanConfigurer(@Qualifier(value="delegatedAuthenticationSaml2WebflowConfigurer") CasWebflowConfigurer delegatedAuthenticationSaml2WebflowConfigurer, ConfigurableApplicationContext applicationContext) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).alwaysMatch().supply(() -> plan -> plan.registerWebflowConfigurer(delegatedAuthenticationSaml2WebflowConfigurer)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientSaml2EndpointConfigurer"})
        public CasWebSecurityConfigurer<Void> delegatedClientSaml2EndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(Strings.CI.prependIfMissing("/sp", (CharSequence)"/", new CharSequence[0]));
                }
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedSaml2ClientMetadataController"})
        public DelegatedSaml2ClientMetadataController delegatedSaml2ClientMetadataController(@Qualifier(value="delegatedIdentityProviders") DelegatedIdentityProviders identityProviders, @Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean configBean) {
            return new DelegatedSaml2ClientMetadataController(identityProviders, configBean);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientsSaml2EndpointContributor"})
        public DelegatedClientsEndpointContributor delegatedClientsSaml2EndpointContributor() {
            return new DelegatedClientsSaml2EndpointContributor();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedSaml2ClientBuilder"})
        public ConfigurableDelegatedClientBuilder delegatedSaml2ClientBuilder(@Qualifier(value="shibboleth.OpenSAMLConfig") OpenSamlConfigBean configBean, @Qualifier(value="delegatedSaml2ClientSAMLMessageStoreFactory") ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, @Qualifier(value="casSslContext") CasSSLContext casSslContext) {
            return new DelegatedClientSaml2Builder(casSslContext, samlMessageStoreFactory, configBean);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"delegatedClientSaml2SessionManager"})
        public DelegatedClientSessionManager delegatedClientSaml2SessionManager(@Qualifier(value="delegatedClientAuthenticationConfigurationContext") ObjectProvider<DelegatedClientAuthenticationConfigurationContext> contextProvider) {
            return new DelegatedClientSaml2SessionManager(contextProvider);
        }
    }
}

