/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.CASSPClientAppTO;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.to.SAML2SPClientAppTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;

public class ClientAppDataBinderImpl
implements ClientAppDataBinder {
    protected final PolicyDAO policyDAO;
    protected final RealmSearchDAO realmSearchDAO;
    protected final EntityFactory entityFactory;

    public ClientAppDataBinderImpl(PolicyDAO policyDAO, RealmSearchDAO realmSearchDAO, EntityFactory entityFactory) {
        this.policyDAO = policyDAO;
        this.realmSearchDAO = realmSearchDAO;
        this.entityFactory = entityFactory;
    }

    public <T extends ClientApp> T create(ClientAppTO clientAppTO) {
        if (clientAppTO instanceof SAML2SPClientAppTO) {
            SAML2SPClientAppTO sAML2SPClientAppTO = (SAML2SPClientAppTO)clientAppTO;
            return (T)this.doCreate(sAML2SPClientAppTO);
        }
        if (clientAppTO instanceof OIDCRPClientAppTO) {
            OIDCRPClientAppTO oIDCRPClientAppTO = (OIDCRPClientAppTO)clientAppTO;
            return (T)this.doCreate(oIDCRPClientAppTO);
        }
        if (clientAppTO instanceof CASSPClientAppTO) {
            CASSPClientAppTO cASSPClientAppTO = (CASSPClientAppTO)clientAppTO;
            return (T)this.doCreate(cASSPClientAppTO);
        }
        throw new IllegalArgumentException("Unsupported client app: " + clientAppTO.getClass().getName());
    }

    public <T extends ClientApp> void update(T clientApp, ClientAppTO clientAppTO) {
        ClientAppTO clientAppTO2 = clientAppTO;
        Objects.requireNonNull(clientAppTO2);
        ClientAppTO clientAppTO3 = clientAppTO2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SAML2SPClientAppTO.class, OIDCRPClientAppTO.class, CASSPClientAppTO.class}, (Object)clientAppTO3, n)) {
            case 0: {
                SAML2SPClientAppTO saml2sp = (SAML2SPClientAppTO)clientAppTO3;
                this.doUpdate((SAML2SPClientApp)clientApp, saml2sp);
                break;
            }
            case 1: {
                OIDCRPClientAppTO oidcrp = (OIDCRPClientAppTO)clientAppTO3;
                this.doUpdate((OIDCRPClientApp)clientApp, oidcrp);
                break;
            }
            case 2: {
                CASSPClientAppTO cassp = (CASSPClientAppTO)clientAppTO3;
                this.doUpdate((CASSPClientApp)clientApp, cassp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported client app: " + clientAppTO.getClass().getName());
            }
        }
    }

    public <T extends ClientAppTO> T getClientAppTO(ClientApp clientApp) {
        if (clientApp instanceof SAML2SPClientApp) {
            SAML2SPClientApp sAML2SPClientApp = (SAML2SPClientApp)clientApp;
            return (T)this.getSAMLClientAppTO(sAML2SPClientApp);
        }
        if (clientApp instanceof OIDCRPClientApp) {
            OIDCRPClientApp oIDCRPClientApp = (OIDCRPClientApp)clientApp;
            return (T)this.getOIDCClientAppTO(oIDCRPClientApp);
        }
        if (clientApp instanceof CASSPClientApp) {
            CASSPClientApp cASSPClientApp = (CASSPClientApp)clientApp;
            return (T)this.getCASClientAppTO(cASSPClientApp);
        }
        throw new IllegalArgumentException("Unsupported client app: " + clientApp.getClass().getName());
    }

    protected SAML2SPClientApp doCreate(SAML2SPClientAppTO clientAppTO) {
        SAML2SPClientApp saml2sp = (SAML2SPClientApp)this.entityFactory.newEntity(SAML2SPClientApp.class);
        this.doUpdate(saml2sp, clientAppTO);
        return saml2sp;
    }

    protected CASSPClientApp doCreate(CASSPClientAppTO clientAppTO) {
        CASSPClientApp saml2sp = (CASSPClientApp)this.entityFactory.newEntity(CASSPClientApp.class);
        this.doUpdate(saml2sp, clientAppTO);
        return saml2sp;
    }

    protected void doUpdate(SAML2SPClientApp clientApp, SAML2SPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setEntityId(clientAppTO.getEntityId());
        if (clientAppTO.getIdp() != null && !"Syncope".equals(clientAppTO.getIdp())) {
            clientApp.setIdp(clientAppTO.getIdp());
        }
        clientApp.setMetadataLocation(clientAppTO.getMetadataLocation());
        clientApp.setMetadataSignatureLocation(clientAppTO.getMetadataSignatureLocation());
        clientApp.setSignAssertions(clientAppTO.isSignAssertions());
        clientApp.setSignResponses(clientAppTO.isSignResponses());
        clientApp.setEncryptionOptional(clientAppTO.isEncryptionOptional());
        clientApp.setEncryptAssertions(clientAppTO.isEncryptAssertions());
        clientApp.setRequiredAuthenticationContextClass(clientAppTO.getRequiredAuthenticationContextClass());
        clientApp.setRequiredNameIdFormat(clientAppTO.getRequiredNameIdFormat());
        clientApp.setSkewAllowance(clientAppTO.getSkewAllowance());
        clientApp.setNameIdQualifier(clientAppTO.getNameIdQualifier());
        clientApp.getAssertionAudiences().clear();
        clientApp.getAssertionAudiences().addAll(clientAppTO.getAssertionAudiences());
        clientApp.setServiceProviderNameIdQualifier(clientAppTO.getServiceProviderNameIdQualifier());
        clientApp.getSigningSignatureAlgorithms().clear();
        clientApp.getSigningSignatureAlgorithms().addAll(clientAppTO.getSigningSignatureAlgorithms());
        clientApp.getSigningSignatureReferenceDigestMethods().clear();
        clientApp.getSigningSignatureReferenceDigestMethods().addAll(clientAppTO.getSigningSignatureReferenceDigestMethods());
        clientApp.getEncryptionKeyAlgorithms().clear();
        clientApp.getEncryptionKeyAlgorithms().addAll(clientAppTO.getEncryptionKeyAlgorithms());
        clientApp.getEncryptionDataAlgorithms().clear();
        clientApp.getEncryptionDataAlgorithms().addAll(clientAppTO.getEncryptionDataAlgorithms());
        clientApp.getSigningSignatureBlackListedAlgorithms().clear();
        clientApp.getSigningSignatureBlackListedAlgorithms().addAll(clientAppTO.getSigningSignatureBlackListedAlgorithms());
        clientApp.getEncryptionBlackListedAlgorithms().clear();
        clientApp.getEncryptionBlackListedAlgorithms().addAll(clientAppTO.getEncryptionBlackListedAlgorithms());
    }

    protected void copyToTO(ClientApp clientApp, ClientAppTO clientAppTO) {
        clientAppTO.setKey(clientApp.getKey());
        clientAppTO.setRealm((String)Optional.ofNullable(clientApp.getRealm()).map(Realm::getFullPath).orElse(null));
        clientAppTO.setName(clientApp.getName());
        clientAppTO.setClientAppId(clientApp.getClientAppId());
        clientAppTO.setEvaluationOrder(clientApp.getEvaluationOrder());
        clientAppTO.setDescription(clientApp.getDescription());
        clientAppTO.setLogo(clientApp.getLogo());
        clientAppTO.setTheme(clientApp.getTheme());
        clientAppTO.setInformationUrl(clientApp.getInformationUrl());
        clientAppTO.setPrivacyUrl(clientApp.getPrivacyUrl());
        clientAppTO.setUsernameAttributeProviderConf(clientApp.getUsernameAttributeProviderConf());
        clientAppTO.setAuthPolicy((String)Optional.ofNullable(clientApp.getAuthPolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.setAccessPolicy((String)Optional.ofNullable(clientApp.getAccessPolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.setAttrReleasePolicy((String)Optional.ofNullable(clientApp.getAttrReleasePolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.setTicketExpirationPolicy((String)Optional.ofNullable(clientApp.getTicketExpirationPolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.getProperties().addAll(clientApp.getProperties());
        clientAppTO.setLogoutType(clientApp.getLogoutType());
    }

    protected SAML2SPClientAppTO getSAMLClientAppTO(SAML2SPClientApp clientApp) {
        SAML2SPClientAppTO clientAppTO = new SAML2SPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setIdp((String)clientApp.getIdp().orElse(null));
        clientAppTO.setEntityId(clientApp.getEntityId());
        clientAppTO.setMetadataLocation(clientApp.getMetadataLocation());
        clientAppTO.setMetadataSignatureLocation(clientApp.getMetadataSignatureLocation());
        clientAppTO.setSignAssertions(clientApp.isSignAssertions());
        clientAppTO.setSignResponses(clientApp.isSignResponses());
        clientAppTO.setEncryptionOptional(clientApp.isEncryptionOptional());
        clientAppTO.setEncryptAssertions(clientApp.isEncryptAssertions());
        clientAppTO.setRequiredAuthenticationContextClass(clientApp.getRequiredAuthenticationContextClass());
        clientAppTO.setRequiredNameIdFormat(clientApp.getRequiredNameIdFormat());
        clientAppTO.setSkewAllowance(clientApp.getSkewAllowance());
        clientAppTO.setNameIdQualifier(clientApp.getNameIdQualifier());
        clientAppTO.getAssertionAudiences().addAll(clientApp.getAssertionAudiences());
        clientAppTO.setServiceProviderNameIdQualifier(clientApp.getServiceProviderNameIdQualifier());
        clientAppTO.getSigningSignatureAlgorithms().addAll(clientApp.getSigningSignatureAlgorithms());
        clientAppTO.getSigningSignatureReferenceDigestMethods().addAll(clientApp.getSigningSignatureReferenceDigestMethods());
        clientAppTO.getEncryptionKeyAlgorithms().addAll(clientApp.getEncryptionKeyAlgorithms());
        clientAppTO.getEncryptionDataAlgorithms().addAll(clientApp.getEncryptionDataAlgorithms());
        clientAppTO.getSigningSignatureBlackListedAlgorithms().addAll(clientApp.getSigningSignatureBlackListedAlgorithms());
        clientAppTO.getEncryptionBlackListedAlgorithms().addAll(clientApp.getEncryptionBlackListedAlgorithms());
        return clientAppTO;
    }

    protected OIDCRPClientApp doCreate(OIDCRPClientAppTO clientAppTO) {
        OIDCRPClientApp oidcrp = (OIDCRPClientApp)this.entityFactory.newEntity(OIDCRPClientApp.class);
        this.doUpdate(oidcrp, clientAppTO);
        return oidcrp;
    }

    protected void doUpdate(OIDCRPClientApp clientApp, OIDCRPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setClientId(clientAppTO.getClientId());
        clientApp.setClientSecret(clientAppTO.getClientSecret());
        clientApp.setIdTokenIssuer(clientAppTO.getIdTokenIssuer());
        clientApp.setSignIdToken(clientAppTO.isSignIdToken());
        clientApp.setIdTokenSigningAlg(clientAppTO.getIdTokenSigningAlg());
        clientApp.setEncryptIdToken(clientAppTO.isEncryptIdToken());
        clientApp.setIdTokenEncryptionAlg(clientAppTO.getIdTokenEncryptionAlg());
        clientApp.setIdTokenEncryptionEncoding(clientAppTO.getIdTokenEncryptionEncoding());
        clientApp.setUserInfoSigningAlg(clientAppTO.getUserInfoSigningAlg());
        clientApp.setUserInfoEncryptedResponseAlg(clientAppTO.getUserInfoEncryptedResponseAlg());
        clientApp.setUserInfoEncryptedResponseEncoding(clientAppTO.getUserInfoEncryptedResponseEncoding());
        clientApp.setJwtAccessToken(clientAppTO.isJwtAccessToken());
        clientApp.setBypassApprovalPrompt(clientAppTO.isBypassApprovalPrompt());
        clientApp.setGenerateRefreshToken(clientAppTO.isGenerateRefreshToken());
        clientApp.setSubjectType(clientAppTO.getSubjectType());
        clientApp.setApplicationType(clientAppTO.getApplicationType());
        clientApp.getRedirectUris().clear();
        clientApp.getRedirectUris().addAll(clientAppTO.getRedirectUris());
        clientApp.getSupportedGrantTypes().clear();
        clientApp.getSupportedGrantTypes().addAll(clientAppTO.getSupportedGrantTypes());
        clientApp.getSupportedResponseTypes().clear();
        clientApp.getSupportedResponseTypes().addAll(clientAppTO.getSupportedResponseTypes());
        clientApp.getScopes().clear();
        clientApp.getScopes().addAll(clientAppTO.getScopes());
        clientApp.setLogoutUri(clientAppTO.getLogoutUri());
        clientApp.setJwks(clientAppTO.getJwks());
        clientApp.setJwksUri(clientAppTO.getJwksUri());
        clientApp.setTokenEndpointAuthenticationMethod(clientAppTO.getTokenEndpointAuthenticationMethod());
        clientApp.setAccessTokenMaxActiveTokens(clientAppTO.getAccessTokenMaxActiveTokens());
        clientApp.setAccessTokenMaxTimeToLive(clientAppTO.getAccessTokenMaxTimeToLive());
        clientApp.setAccessTokenTimeToKill(clientAppTO.getAccessTokenTimeToKill());
        clientApp.setRefreshTokenMaxActiveTokens(clientAppTO.getRefreshTokenMaxActiveTokens());
        clientApp.setRefreshTokenTimeToKill(clientAppTO.getRefreshTokenTimeToKill());
        clientApp.setDeviceTokenTimeToKill(clientAppTO.getDeviceTokenTimeToKill());
    }

    protected OIDCRPClientAppTO getOIDCClientAppTO(OIDCRPClientApp clientApp) {
        OIDCRPClientAppTO clientAppTO = new OIDCRPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setClientId(clientApp.getClientId());
        clientAppTO.setClientSecret(clientApp.getClientSecret());
        clientAppTO.setIdTokenIssuer(clientApp.getIdTokenIssuer());
        clientAppTO.setSignIdToken(clientApp.isSignIdToken());
        clientAppTO.setIdTokenSigningAlg(clientApp.getIdTokenSigningAlg());
        clientAppTO.setEncryptIdToken(clientApp.isEncryptIdToken());
        clientAppTO.setIdTokenEncryptionAlg(clientApp.getIdTokenEncryptionAlg());
        clientAppTO.setIdTokenEncryptionEncoding(clientApp.getIdTokenEncryptionEncoding());
        clientAppTO.setUserInfoSigningAlg(clientApp.getUserInfoSigningAlg());
        clientAppTO.setUserInfoEncryptedResponseAlg(clientApp.getUserInfoEncryptedResponseAlg());
        clientAppTO.setUserInfoEncryptedResponseEncoding(clientApp.getUserInfoEncryptedResponseEncoding());
        clientAppTO.setJwtAccessToken(clientApp.isJwtAccessToken());
        clientAppTO.setBypassApprovalPrompt(clientApp.isBypassApprovalPrompt());
        clientAppTO.setGenerateRefreshToken(clientApp.isGenerateRefreshToken());
        clientAppTO.setSubjectType(clientApp.getSubjectType());
        clientAppTO.setApplicationType(clientApp.getApplicationType());
        clientAppTO.getRedirectUris().addAll(clientApp.getRedirectUris());
        clientAppTO.getSupportedGrantTypes().clear();
        clientAppTO.getSupportedGrantTypes().addAll(clientApp.getSupportedGrantTypes());
        clientAppTO.getSupportedResponseTypes().clear();
        clientAppTO.getSupportedResponseTypes().addAll(clientApp.getSupportedResponseTypes());
        clientAppTO.getScopes().addAll(clientApp.getScopes());
        clientAppTO.setLogoutUri(clientApp.getLogoutUri());
        clientAppTO.setJwks(clientApp.getJwks());
        clientAppTO.setJwksUri(clientApp.getJwksUri());
        clientAppTO.setTokenEndpointAuthenticationMethod(clientApp.getTokenEndpointAuthenticationMethod());
        clientAppTO.setAccessTokenMaxActiveTokens(clientApp.getAccessTokenMaxActiveTokens());
        clientAppTO.setAccessTokenMaxTimeToLive(clientApp.getAccessTokenMaxTimeToLive());
        clientAppTO.setAccessTokenTimeToKill(clientApp.getAccessTokenTimeToKill());
        clientAppTO.setRefreshTokenTimeToKill(clientApp.getRefreshTokenTimeToKill());
        clientAppTO.setRefreshTokenMaxActiveTokens(clientApp.getRefreshTokenMaxActiveTokens());
        clientAppTO.setDeviceTokenTimeToKill(clientApp.getDeviceTokenTimeToKill());
        return clientAppTO;
    }

    protected void doUpdate(CASSPClientApp clientApp, CASSPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setServiceId(clientAppTO.getServiceId());
    }

    protected CASSPClientAppTO getCASClientAppTO(CASSPClientApp clientApp) {
        CASSPClientAppTO clientAppTO = new CASSPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setServiceId(clientApp.getServiceId());
        return clientAppTO;
    }

    protected void copyToEntity(ClientApp clientApp, ClientAppTO clientAppTO) {
        Policy policy;
        Optional.ofNullable(clientAppTO.getRealm()).flatMap(arg_0 -> ((RealmSearchDAO)this.realmSearchDAO).findByFullPath(arg_0)).ifPresentOrElse(arg_0 -> ((ClientApp)clientApp).setRealm(arg_0), () -> clientApp.setRealm(null));
        clientApp.setName(clientAppTO.getName());
        clientApp.setClientAppId(clientAppTO.getClientAppId());
        clientApp.setEvaluationOrder(clientAppTO.getEvaluationOrder());
        clientApp.setDescription(clientAppTO.getDescription());
        clientApp.setLogo(clientAppTO.getLogo());
        clientApp.setTheme(clientAppTO.getTheme());
        clientApp.setInformationUrl(clientAppTO.getInformationUrl());
        clientApp.setPrivacyUrl(clientAppTO.getPrivacyUrl());
        clientApp.setUsernameAttributeProviderConf(clientAppTO.getUsernameAttributeProviderConf());
        if (clientAppTO.getAuthPolicy() == null) {
            clientApp.setAuthPolicy(null);
        } else {
            policy = this.policyDAO.findById(clientAppTO.getAuthPolicy()).orElse(null);
            if (policy instanceof AuthPolicy) {
                AuthPolicy authPolicy = (AuthPolicy)policy;
                clientApp.setAuthPolicy(authPolicy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AuthPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (clientAppTO.getAccessPolicy() == null) {
            clientApp.setAccessPolicy(null);
        } else {
            policy = this.policyDAO.findById(clientAppTO.getAccessPolicy()).orElse(null);
            if (policy instanceof AccessPolicy) {
                AccessPolicy accessPolicy = (AccessPolicy)policy;
                clientApp.setAccessPolicy(accessPolicy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccessPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (clientAppTO.getAttrReleasePolicy() == null) {
            clientApp.setAttrReleasePolicy(null);
        } else {
            policy = this.policyDAO.findById(clientAppTO.getAttrReleasePolicy()).orElse(null);
            if (policy instanceof AttrReleasePolicy) {
                AttrReleasePolicy attrReleasePolicy = (AttrReleasePolicy)policy;
                clientApp.setAttrReleasePolicy(attrReleasePolicy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AttrReleasePolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (clientAppTO.getTicketExpirationPolicy() == null) {
            clientApp.setTicketExpirationPolicy(null);
        } else {
            policy = this.policyDAO.findById(clientAppTO.getTicketExpirationPolicy()).orElse(null);
            if (policy instanceof TicketExpirationPolicy) {
                TicketExpirationPolicy ticketExpirationPolicy = (TicketExpirationPolicy)policy;
                clientApp.setTicketExpirationPolicy(ticketExpirationPolicy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + TicketExpirationPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        clientApp.setProperties(clientAppTO.getProperties());
        clientApp.setLogoutType(clientAppTO.getLogoutType());
    }
}

