/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RemediationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Remediation;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.InboundTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.ProvisioningManager;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.pushpull.AnyPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.rules.InboundMatch;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPullResultHandler
extends AbstractSyncopeResultHandler<PullTask, InboundActions>
implements AnyPullResultHandler {
    @Autowired
    protected InboundMatcher inboundMatcher;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ConnObjectUtils connObjectUtils;
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected RemediationDAO remediationDAO;
    @Autowired
    protected EntityFactory entityFactory;
    protected final Map<String, Optional<String>> uManagers = new HashMap<String, Optional<String>>();
    protected final Map<String, Optional<String>> gManagers = new HashMap<String, Optional<String>>();

    protected abstract String getName(AnyTO var1);

    protected abstract String getName(AnyCR var1);

    protected abstract ProvisioningManager<?, ?> provisioningManager();

    protected abstract AnyTO doCreate(AnyCR var1, SyncDelta var2);

    protected abstract AnyUR doUpdate(AnyTO var1, AnyUR var2, SyncDelta var3, ProvisioningReport var4);

    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.REQUIRES_NEW)
    public boolean handle(SyncDelta delta) {
        Provision provision = null;
        try {
            provision = (Provision)((PullTask)this.profile.getTask()).getResource().getProvisionByObjectClass(delta.getObject().getObjectClass().getObjectClassValue()).orElseThrow(() -> new JobExecutionException("No provision found on " + String.valueOf(((PullTask)this.profile.getTask()).getResource()) + " for " + String.valueOf(delta.getObject().getObjectClass())));
            String anyType = provision.getAnyType();
            OpEvent.Outcome latestResult = this.doHandle(delta, provision, ((AnyType)this.anyTypeDAO.findById(anyType).orElseThrow(() -> new NotFoundException("AnyType " + anyType))).getKind());
            LOG.debug("Successfully handled {}", (Object)delta);
            if (this.stopRequested) {
                LOG.debug("Stop was requested");
                return false;
            }
            if (((PullTask)this.profile.getTask()).getPullMode() != PullMode.INCREMENTAL) {
                return true;
            }
            return latestResult == OpEvent.Outcome.SUCCESS;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = new ProvisioningReport();
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setAnyType(provision == null ? this.anyUtils().anyTypeKind().name() : provision.getAnyType());
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            ignoreResult.setKey(null);
            ignoreResult.setUidValue(delta.getUid().getUidValue());
            ignoreResult.setName(delta.getObject().getName().getNameValue());
            this.profile.getResults().add(ignoreResult);
            LOG.warn("Ignoring during pull", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Pull failed", (Throwable)e);
            return false;
        }
    }

    protected void throwIgnoreProvisionException(SyncDelta delta, Exception exception) {
        if (exception instanceof IgnoreProvisionException) {
            throw (IgnoreProvisionException)((Object)IgnoreProvisionException.class.cast(exception));
        }
        IgnoreProvisionException ipe = null;
        for (InboundActions action : this.profile.getActions()) {
            if (ipe != null) continue;
            ipe = action.onError(this.profile, (LiveSyncDelta)delta, exception);
        }
        if (ipe != null) {
            throw ipe;
        }
    }

    protected OpEvent.Outcome provision(UnmatchingRule rule, SyncDelta delta, AnyTypeKind anyTypeKind, Provision provision) throws JobExecutionException {
        OpEvent.Outcome resultStatus;
        Throwable output;
        if (!((PullTask)this.profile.getTask()).isPerformCreate()) {
            LOG.debug("PullTask not configured for create");
            this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        Object req = this.connObjectUtils.getAnyCR(delta.getObject(), (InboundTask)this.profile.getTask(), anyTypeKind, provision, true);
        if (rule == UnmatchingRule.ASSIGN) {
            req.getResources().add(((PullTask)this.profile.getTask()).getResource().getKey());
        }
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.CREATE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setName(this.getName((AnyCR)req));
        result.setUidValue(delta.getUid().getUidValue());
        if (this.profile.isDryRun()) {
            result.setKey(null);
            this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        try {
            for (InboundActions action : this.profile.getActions()) {
                if (rule == UnmatchingRule.ASSIGN) {
                    action.beforeAssign(this.profile, (LiveSyncDelta)delta, req);
                    continue;
                }
                if (rule != UnmatchingRule.PROVISION) continue;
                action.beforeProvision(this.profile, (LiveSyncDelta)delta, req);
            }
            result.setName(this.getName((AnyCR)req));
            Optional<String> uManager = Optional.ofNullable(req.getUManager());
            req.setUManager(null);
            Optional<String> gManager = Optional.ofNullable(req.getGManager());
            req.setGManager(null);
            AnyTO created = this.doCreate((AnyCR)req, delta);
            output = created;
            result.setKey(created.getKey());
            result.setName(this.getName(created));
            resultStatus = OpEvent.Outcome.SUCCESS;
            uManager.ifPresent(v -> this.uManagers.put(created.getKey(), Optional.of(v)));
            gManager.ifPresent(v -> this.gManagers.put(created.getKey(), Optional.of(v)));
            for (InboundActions action : this.profile.getActions()) {
                action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)created, result);
            }
            LOG.debug("{} {} successfully created", (Object)created.getType(), (Object)created.getKey());
        }
        catch (PropagationException e) {
            LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
            output = e;
            resultStatus = OpEvent.Outcome.FAILURE;
        }
        catch (Exception e) {
            this.throwIgnoreProvisionException(delta, e);
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOG.error("Could not create {} {} ", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
            output = e;
            if (((PullTask)this.profile.getTask()).isRemediation()) {
                resultStatus = OpEvent.Outcome.SUCCESS;
                this.createRemediation(null, (AnyCR)req, null, result, delta);
            }
            resultStatus = OpEvent.Outcome.FAILURE;
        }
        this.end(provision.getAnyType(), UnmatchingRule.toOp((UnmatchingRule)rule), resultStatus, null, output, delta, new Object[0]);
        this.profile.getResults().add(result);
        return resultStatus;
    }

    protected OpEvent.Outcome update(SyncDelta delta, InboundMatch match, Provision provision) throws JobExecutionException {
        Throwable output;
        OpEvent.Outcome resultStatus;
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)MatchingRule.UPDATE), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to update {}", (Object)match);
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.UPDATE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setKey(match.getAny().getKey());
        result.setUidValue(delta.getUid().getUidValue());
        AnyTO before = this.getAnyTO(match.getAny());
        if (before == null) {
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
        } else {
            result.setName(this.getName(before));
        }
        if (this.profile.isDryRun()) {
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)MatchingRule.UPDATE), OpEvent.Outcome.SUCCESS, before, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        AnyUR req = null;
        if (before == null) {
            resultStatus = OpEvent.Outcome.FAILURE;
            output = null;
        } else {
            try {
                req = (AnyUR)this.connObjectUtils.getAnyUR(before.getKey(), delta.getObject(), before, (InboundTask)this.profile.getTask(), match.getAny().getType().getKind(), provision);
                for (InboundActions action : this.profile.getActions()) {
                    action.beforeUpdate(this.profile, (LiveSyncDelta)delta, (EntityTO)before, req);
                }
                Optional.ofNullable(req.getUManager()).ifPresent(patch -> this.uManagers.put(before.getKey(), patch.getOperation() == PatchOperation.ADD_REPLACE ? Optional.of((String)patch.getValue()) : Optional.empty()));
                req.setUManager(null);
                Optional.ofNullable(req.getGManager()).ifPresent(patch -> this.gManagers.put(before.getKey(), patch.getOperation() == PatchOperation.ADD_REPLACE ? Optional.of((String)patch.getValue()) : Optional.empty()));
                req.setGManager(null);
                req = this.doUpdate(before, req, delta, result);
                AnyTO updated = AnyOperations.patch((AnyTO)before, (AnyUR)req);
                for (InboundActions action : this.profile.getActions()) {
                    action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)updated, result);
                }
                output = updated;
                resultStatus = OpEvent.Outcome.SUCCESS;
                result.setName(this.getName(updated));
                LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
            }
            catch (PropagationException e) {
                LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                output = e;
                resultStatus = OpEvent.Outcome.FAILURE;
            }
            catch (Exception e) {
                this.throwIgnoreProvisionException(delta, e);
                result.setStatus(ProvisioningReport.Status.FAILURE);
                result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                output = e;
                if (((PullTask)this.profile.getTask()).isRemediation()) {
                    resultStatus = OpEvent.Outcome.SUCCESS;
                    this.createRemediation(null, null, req, result, delta);
                }
                resultStatus = OpEvent.Outcome.FAILURE;
            }
        }
        this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)MatchingRule.UPDATE), resultStatus, before, output, delta, req);
        this.profile.getResults().add(result);
        return resultStatus;
    }

    protected OpEvent.Outcome deprovision(MatchingRule matchingRule, SyncDelta delta, InboundMatch match, Provision provision) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)matchingRule), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to deprovision {}", (Object)match);
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.DELETE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setKey(match.getAny().getKey());
        result.setUidValue(delta.getUid().getUidValue());
        AnyTO before = this.getAnyTO(match.getAny());
        if (before == null) {
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
        }
        OpEvent.Outcome resultStatus = OpEvent.Outcome.SUCCESS;
        if (!this.profile.isDryRun()) {
            Throwable output;
            if (before == null) {
                resultStatus = OpEvent.Outcome.FAILURE;
                output = null;
            } else {
                result.setName(this.getName(before));
                try {
                    if (matchingRule == MatchingRule.UNASSIGN) {
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                        }
                    } else if (matchingRule == MatchingRule.DEPROVISION) {
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                        }
                    }
                    PropagationByResource propByRes = new PropagationByResource();
                    propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)((PullTask)this.profile.getTask()).getResource().getKey()));
                    this.taskExecutor.execute((Collection)this.propagationManager.getDeleteTasks(match.getAny().getType().getKind(), match.getAny().getKey(), propByRes, null, null), false, this.securityProperties.getAdminUser());
                    if (matchingRule == MatchingRule.UNASSIGN) {
                        AnyUR req = this.anyUtils().newAnyUR(match.getAny().getKey());
                        req.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                        output = this.doUpdate(before, req, delta, result);
                    } else {
                        output = this.getAnyTO(match.getAny());
                    }
                    for (InboundActions action : this.profile.getActions()) {
                        action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)AnyTO.class.cast(output), result);
                    }
                    resultStatus = OpEvent.Outcome.SUCCESS;
                    LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                    output = e;
                    resultStatus = OpEvent.Outcome.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                    output = e;
                    resultStatus = OpEvent.Outcome.FAILURE;
                }
            }
            this.end(provision.getAnyType(), MatchingRule.toOp((MatchingRule)matchingRule), resultStatus, before, output, delta, new Object[0]);
        }
        this.profile.getResults().add(result);
        return resultStatus;
    }

    protected OpEvent.Outcome link(SyncDelta delta, InboundMatch match, Provision provision, boolean unlink) throws JobExecutionException {
        if (!((PullTask)this.profile.getTask()).isPerformUpdate()) {
            LOG.debug("PullTask not configured for update");
            this.end(provision.getAnyType(), unlink ? MatchingRule.toOp((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toOp((MatchingRule)MatchingRule.LINK), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to " + (unlink ? "un" : "") + "link {}", (Object)match);
        ProvisioningReport result = new ProvisioningReport();
        result.setOperation(ResourceOperation.NONE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setKey(match.getAny().getKey());
        result.setUidValue(delta.getUid().getUidValue());
        AnyTO before = this.getAnyTO(match.getAny());
        if (before == null) {
            result.setStatus(ProvisioningReport.Status.FAILURE);
            result.setMessage(String.format("Any '%s(%s)' not found", provision.getAnyType(), match));
        }
        OpEvent.Outcome resultStatus = OpEvent.Outcome.SUCCESS;
        if (!this.profile.isDryRun()) {
            Throwable output;
            AnyUR effectiveReq = null;
            if (before == null) {
                resultStatus = OpEvent.Outcome.FAILURE;
                output = null;
            } else {
                result.setName(this.getName(before));
                try {
                    if (unlink) {
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                        }
                    } else {
                        for (InboundActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                        }
                    }
                    AnyUR req = this.anyUtils().newAnyUR(before.getKey());
                    req.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PullTask)this.profile.getTask()).getResource().getKey())).build());
                    effectiveReq = (AnyUR)this.update(req).getResult();
                    output = AnyOperations.patch((AnyTO)before, (AnyUR)effectiveReq);
                    for (InboundActions action : this.profile.getActions()) {
                        action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)AnyTO.class.cast(output), result);
                    }
                    resultStatus = OpEvent.Outcome.SUCCESS;
                    LOG.debug("{} {} successfully updated", (Object)provision.getAnyType(), (Object)match);
                }
                catch (PropagationException e) {
                    LOG.error("Could not propagate {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                    output = e;
                    resultStatus = OpEvent.Outcome.FAILURE;
                }
                catch (Exception e) {
                    this.throwIgnoreProvisionException(delta, e);
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOG.error("Could not update {} {}", new Object[]{provision.getAnyType(), delta.getUid().getUidValue(), e});
                    output = e;
                    resultStatus = OpEvent.Outcome.FAILURE;
                }
            }
            this.end(provision.getAnyType(), unlink ? MatchingRule.toOp((MatchingRule)MatchingRule.UNLINK) : MatchingRule.toOp((MatchingRule)MatchingRule.LINK), resultStatus, before, output, delta, effectiveReq);
            this.profile.getResults().add(result);
        }
        return resultStatus;
    }

    protected OpEvent.Outcome delete(SyncDelta delta, InboundMatch match, Provision provision) {
        if (!((PullTask)this.profile.getTask()).isPerformDelete()) {
            LOG.debug("PullTask not configured for delete");
            this.end(provision.getAnyType(), ResourceOperation.DELETE.name().toLowerCase(), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
            return OpEvent.Outcome.SUCCESS;
        }
        LOG.debug("About to delete {}", (Object)match);
        OpEvent.Outcome resultStatus = OpEvent.Outcome.SUCCESS;
        ProvisioningReport result = new ProvisioningReport();
        try {
            AnyTO before = this.getAnyTO(match.getAny());
            result.setKey(match.getAny().getKey());
            result.setName(this.getName(before));
            result.setOperation(ResourceOperation.DELETE);
            result.setAnyType(provision.getAnyType());
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            result.setUidValue(delta.getUid().getUidValue());
            if (!this.profile.isDryRun()) {
                Exception output;
                block10: {
                    for (Object action : this.profile.getActions()) {
                        action.beforeDelete(this.profile, (LiveSyncDelta)delta, (EntityTO)before);
                    }
                    try {
                        this.provisioningManager().delete(match.getAny().getKey(), Set.of(((PullTask)this.profile.getTask()).getResource().getKey()), true, this.profile.getExecutor(), this.profile.getContext());
                        output = null;
                        resultStatus = OpEvent.Outcome.SUCCESS;
                        for (InboundActions action : this.profile.getActions()) {
                            action.after(this.profile, (LiveSyncDelta)delta, (EntityTO)before, result);
                        }
                    }
                    catch (Exception e) {
                        this.throwIgnoreProvisionException(delta, e);
                        result.setStatus(ProvisioningReport.Status.FAILURE);
                        result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e));
                        LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType(), match, e});
                        output = e;
                        if (!((PullTask)this.profile.getTask()).isRemediation()) break block10;
                        resultStatus = OpEvent.Outcome.SUCCESS;
                        this.createRemediation(match.getAny().getKey(), null, null, result, delta);
                    }
                }
                this.end(provision.getAnyType(), ResourceOperation.DELETE.name().toLowerCase(), resultStatus, before, output, delta, new Object[0]);
            }
            this.profile.getResults().add(result);
        }
        catch (NotFoundException e) {
            LOG.error("Could not find {} {}", new Object[]{provision.getAnyType(), match, e});
        }
        catch (DelegatedAdministrationException e) {
            LOG.error("Not allowed to read {} {}", new Object[]{provision.getAnyType(), match, e});
        }
        catch (Exception e) {
            LOG.error("Could not delete {} {}", new Object[]{provision.getAnyType(), match, e});
        }
        return resultStatus;
    }

    protected OpEvent.Outcome ignore(SyncDelta delta, InboundMatch match, Provision provision, boolean matching, String ... message) {
        LOG.debug("About to ignore {}", (Object)match);
        ProvisioningReport result = new ProvisioningReport();
        result.setKey((String)Optional.ofNullable(match).map(InboundMatch::getAny).map(Entity::getKey).orElse(null));
        result.setName(delta.getObject().getUid().getUidValue());
        result.setOperation(ResourceOperation.NONE);
        result.setAnyType(provision.getAnyType());
        result.setStatus(ProvisioningReport.Status.SUCCESS);
        result.setUidValue(delta.getUid().getUidValue());
        if (message != null && message.length >= 1) {
            result.setMessage(message[0]);
        }
        this.profile.getResults().add(result);
        this.end(provision.getAnyType(), matching ? MatchingRule.toOp((MatchingRule)MatchingRule.IGNORE) : UnmatchingRule.toOp((UnmatchingRule)UnmatchingRule.IGNORE), OpEvent.Outcome.SUCCESS, null, null, delta, new Object[0]);
        return OpEvent.Outcome.SUCCESS;
    }

    protected OpEvent.Outcome handleAny(SyncDelta delta, InboundMatch match, AnyTypeKind anyTypeKind, Provision provision) throws JobExecutionException {
        OpEvent.Outcome result = OpEvent.Outcome.SUCCESS;
        block0 : switch (delta.getDeltaType()) {
            case CREATE: 
            case UPDATE: 
            case CREATE_OR_UPDATE: {
                if (match.getAny() == null) {
                    switch (((PullTask)this.profile.getTask()).getUnmatchingRule()) {
                        case ASSIGN: 
                        case PROVISION: {
                            result = this.provision(((PullTask)this.profile.getTask()).getUnmatchingRule(), delta, anyTypeKind, provision);
                            break block0;
                        }
                        case IGNORE: {
                            result = this.ignore(delta, null, provision, false, new String[0]);
                            break block0;
                        }
                    }
                    break;
                }
                switch (((PullTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        result = this.update(delta, match, provision);
                        break block0;
                    }
                    case DEPROVISION: 
                    case UNASSIGN: {
                        result = this.deprovision(((PullTask)this.profile.getTask()).getMatchingRule(), delta, match, provision);
                        break block0;
                    }
                    case LINK: {
                        result = this.link(delta, match, provision, false);
                        break block0;
                    }
                    case UNLINK: {
                        result = this.link(delta, match, provision, true);
                        break block0;
                    }
                    case IGNORE: {
                        result = this.ignore(delta, match, provision, true, new String[0]);
                        break block0;
                    }
                }
                break;
            }
            case DELETE: {
                result = match.getAny() == null ? OpEvent.Outcome.SUCCESS : this.delete(delta, match, provision);
                break;
            }
        }
        return result;
    }

    protected OpEvent.Outcome handleLinkedAccount(SyncDelta delta, InboundMatch match, Provision provision) throws JobExecutionException {
        LOG.warn("Unexpected linked account found for {}: {}", (Object)provision.getAnyType(), (Object)match);
        return OpEvent.Outcome.SUCCESS;
    }

    protected OpEvent.Outcome doHandle(SyncDelta delta, Provision provision, AnyTypeKind anyTypeKind) throws JobExecutionException {
        LOG.debug("Process {} for {} as {}", new Object[]{delta.getDeltaType(), delta.getUid().getUidValue(), delta.getObject().getObjectClass()});
        SyncDelta finalDelta = delta;
        for (InboundActions action : this.profile.getActions()) {
            finalDelta = (SyncDelta)action.preprocess(this.profile, (LiveSyncDelta)finalDelta);
        }
        LOG.debug("Transformed {} for {} as {}", new Object[]{finalDelta.getDeltaType(), finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass()});
        try {
            List<InboundMatch> matches = this.inboundMatcher.match(finalDelta, ((PullTask)this.profile.getTask()).getResource(), provision, anyTypeKind);
            LOG.debug("Match(es) found for {} as {}: {}", new Object[]{finalDelta.getUid().getUidValue(), finalDelta.getObject().getObjectClass(), matches});
            if (matches.isEmpty()) {
                LOG.debug("Nothing to do");
                return OpEvent.Outcome.SUCCESS;
            }
            InboundMatch match = matches.getFirst();
            if (matches.size() > 1) {
                switch (this.profile.getConflictResolutionAction()) {
                    case IGNORE: {
                        throw new IgnoreProvisionException("More than one match found for " + finalDelta.getObject().getUid().getUidValue() + ": " + String.valueOf(matches));
                    }
                    case LASTMATCH: {
                        match = matches.getLast();
                        break;
                    }
                }
            }
            if (match.getMatchTarget() == MatchType.ANY) {
                return this.handleAny(finalDelta, match, anyTypeKind, provision);
            }
            if (match.getMatchTarget() == MatchType.LINKED_ACCOUNT) {
                return this.handleLinkedAccount(finalDelta, match, provision);
            }
            LOG.debug("Unsupported match target: {}", (Object)match);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn(e.getMessage());
        }
        return OpEvent.Outcome.SUCCESS;
    }

    protected void end(String anyType, String event, OpEvent.Outcome result, Object before, Object output, SyncDelta delta, Object ... furtherInput) {
        this.notificationManager.createTasks(this.profile.getExecutor(), OpEvent.CategoryType.PULL, anyType, ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
        this.auditManager.audit(AuthContextUtils.getDomain(), this.profile.getExecutor(), OpEvent.CategoryType.PULL, anyType, ((PullTask)this.profile.getTask()).getResource().getKey(), event, result, before, output, new Object[]{delta, furtherInput});
    }

    protected void createRemediationIfNeeded(AnyUR anyUR, SyncDelta delta, ProvisioningReport result) {
        if (ProvisioningReport.Status.FAILURE == result.getStatus() && ((PullTask)this.profile.getTask()).isRemediation()) {
            this.createRemediation(null, null, anyUR, result, delta);
        }
    }

    private void createRemediation(String anyKey, AnyCR anyCR, AnyUR anyUR, ProvisioningReport result, SyncDelta delta) {
        Remediation remediation = (Remediation)this.entityFactory.newEntity(Remediation.class);
        remediation.setAnyType((AnyType)this.anyTypeDAO.findById(result.getAnyType()).orElseThrow(() -> new NotFoundException("AnyType " + result.getAnyType())));
        remediation.setOperation(anyUR == null ? ResourceOperation.CREATE : ResourceOperation.UPDATE);
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediation.setPayload(anyKey);
        } else if (anyCR != null) {
            remediation.setPayload(anyCR);
        } else if (anyUR != null) {
            remediation.setPayload(anyUR);
        }
        remediation.setError(result.getMessage());
        remediation.setInstant(OffsetDateTime.now());
        remediation.setRemoteName(delta.getObject().getName().getNameValue());
        this.taskDAO.findById(TaskType.PULL, ((PullTask)this.profile.getTask()).getKey()).map(PullTask.class::cast).ifPresent(arg_0 -> ((Remediation)remediation).setPullTask(arg_0));
        remediation = (Remediation)this.remediationDAO.save((Entity)remediation);
        ProvisioningReport remediationResult = new ProvisioningReport();
        remediationResult.setOperation(remediation.getOperation());
        remediationResult.setAnyType(result.getAnyType());
        remediationResult.setStatus(ProvisioningReport.Status.FAILURE);
        remediationResult.setMessage(remediation.getError());
        if (StringUtils.isNotBlank((CharSequence)anyKey)) {
            remediationResult.setKey(anyKey);
        } else if (anyUR != null) {
            remediationResult.setKey(anyUR.getKey());
        }
        remediationResult.setUidValue(delta.getUid().getUidValue());
        remediationResult.setName(remediation.getRemoteName());
        this.profile.getResults().add(remediationResult);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void setManagers() {
        this.uManagers.forEach((anyKey, uManager) -> {
            Any any = (Any)this.anyUtils().dao().findById(anyKey).orElseThrow(() -> new NotFoundException(String.valueOf(this.anyUtils().anyTypeKind()) + " " + anyKey));
            uManager.ifPresentOrElse(manager -> this.inboundMatcher.match(this.anyTypeDAO.getUser(), (String)manager, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector()).ifPresent(match -> any.setUManager((User)match.getAny())), () -> any.setUManager(null));
            this.anyUtils().dao().save((Entity)any);
        });
        this.gManagers.forEach((anyKey, gManager) -> {
            Any any = (Any)this.anyUtils().dao().findById(anyKey).orElseThrow(() -> new NotFoundException(String.valueOf(this.anyUtils().anyTypeKind()) + " " + anyKey));
            gManager.ifPresentOrElse(manager -> this.inboundMatcher.match(this.anyTypeDAO.getGroup(), (String)manager, ((PullTask)this.profile.getTask()).getResource(), this.profile.getConnector()).ifPresent(match -> any.setGManager((Group)match.getAny())), () -> any.setGManager(null));
            this.anyUtils().dao().save((Entity)any);
        });
    }
}

