/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.syncope.common.lib.to.OrgUnit;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.policy.ProvisioningPolicy;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.StoppableSchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.pushpull.AnyPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.InboundActions;
import org.apache.syncope.core.provisioning.api.pushpull.LiveSyncDeltaMapper;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractPullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.LiveSyncTaskSaver;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LiveSyncJobDelegate
extends AbstractPullExecutor<LiveSyncTask>
implements SyncopePullExecutor,
StoppableSchedTaskJobDelegate {
    @Autowired
    protected LiveSyncTaskSaver liveSyncTaskSaver;
    protected int delaySecondsAcrossInvocations = 5;
    protected LiveSyncDeltaMapper mapper;
    protected List<LiveSyncInfo> infos;
    protected volatile boolean stopRequested = false;

    @Override
    protected void init(final TaskType taskType, final String taskKey, JobExecutionContext context) throws JobExecutionException {
        super.init(taskType, taskKey, context);
        this.delaySecondsAcrossInvocations = ((LiveSyncTask)this.task).getDelaySecondsAcrossInvocations();
        Implementation impl = Optional.ofNullable(((LiveSyncTask)this.task).getLiveSyncDeltaMapper()).orElseThrow(() -> new JobExecutionException("No " + LiveSyncDeltaMapper.class.getSimpleName() + " provided, aborting"));
        try {
            this.mapper = (LiveSyncDeltaMapper)ImplementationManager.build((Implementation)impl);
        }
        catch (Exception e) {
            throw new JobExecutionException("Could not build LIVE_SYNC_DELTA_MAPPER " + impl.getKey(), (Throwable)e);
        }
        PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
        pullTask.setName(((LiveSyncTask)this.task).getName());
        pullTask.setResource(((LiveSyncTask)this.task).getResource());
        pullTask.setMatchingRule(((LiveSyncTask)this.task).getMatchingRule());
        pullTask.setUnmatchingRule(((LiveSyncTask)this.task).getUnmatchingRule());
        pullTask.setPullMode(PullMode.INCREMENTAL);
        pullTask.setPerformCreate(((LiveSyncTask)this.task).isPerformCreate());
        pullTask.setPerformUpdate(((LiveSyncTask)this.task).isPerformUpdate());
        pullTask.setPerformDelete(((LiveSyncTask)this.task).isPerformDelete());
        pullTask.setSyncStatus(((LiveSyncTask)this.task).isSyncStatus());
        pullTask.setDestinationRealm(((LiveSyncTask)this.task).getDestinationRealm());
        pullTask.setRemediation(((LiveSyncTask)this.task).isRemediation());
        pullTask.setConcurrentSettings(((LiveSyncTask)this.task).getConcurrentSettings());
        ((LiveSyncTask)this.task).getTemplates().forEach(atlst -> {
            AnyTemplatePullTask atpt = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
            atpt.setAnyType(atlst.getAnyType());
            atpt.setPullTask(pullTask);
            pullTask.add(atpt);
            atpt.set(atlst.get());
        });
        this.profile = new ProvisioningProfile<PullTask, InboundActions>(this, this.connector, taskType, pullTask, Optional.ofNullable(((LiveSyncTask)this.task).getResource().getInboundPolicy()).map(ProvisioningPolicy::getConflictResolutionAction).orElse(ConflictResolutionAction.IGNORE), this.getInboundActions(((LiveSyncTask)this.task).getActions()), this.executor, context.isDryRun()){
            final /* synthetic */ LiveSyncJobDelegate this$0;
            {
                this.this$0 = this$0;
                super(connector, taskType3, (ProvisioningTask)task, conflictResolutionAction, actions, executor, dryRun);
            }

            public String getContext() {
                return String.valueOf(taskType) + " Task " + taskKey + " '" + ((LiveSyncTask)this.this$0.task).getName() + "'";
            }
        };
        this.dispatcher = this.buildDispatcher();
        this.infos = new ArrayList<LiveSyncInfo>();
        if (((LiveSyncTask)this.task).getResource().getOrgUnit() != null) {
            this.setStatus("Pulling " + ((LiveSyncTask)this.task).getResource().getOrgUnit().getObjectClass());
            OrgUnit orgUnit = ((LiveSyncTask)this.task).getResource().getOrgUnit();
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, orgUnit)));
            OperationOptions options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(orgUnit.getItems().stream()), (String[])moreAttrsToGet.toArray(String[]::new));
            this.dispatcher.addHandlerSupplier(orgUnit.getObjectClass(), () -> {
                RealmPullResultHandler handler = this.buildRealmHandler();
                handler.setProfile(this.profile);
                return handler;
            });
            this.infos.add(new LiveSyncInfo(null, orgUnit, new ObjectClass(orgUnit.getObjectClass()), null, null, options));
            Optional.ofNullable(orgUnit.getSyncToken()).ifPresent(syncToken -> this.setLatestSyncToken(orgUnit.getObjectClass(), ConnObjectUtils.toSyncToken(syncToken)));
        }
        for (Provision provision2 : ((LiveSyncTask)this.task).getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).sorted((Comparator<Provision>)this.provisionSorter).toList()) {
            AnyType anyType = (AnyType)this.anyTypeDAO.findById(provision2.getAnyType()).orElseThrow(() -> new NotFoundException("AnyType" + provision2.getAnyType()));
            PlainSchema uidOnCreate = null;
            if (provision2.getUidOnCreate() != null) {
                uidOnCreate = (PlainSchema)this.plainSchemaDAO.findById(provision2.getUidOnCreate()).orElseThrow(() -> new NotFoundException("PlainSchema " + provision2.getUidOnCreate()));
            }
            this.dispatcher.addHandlerSupplier(provision2.getObjectClass(), () -> {
                AnyPullResultHandler handler = switch (anyType.getKind()) {
                    case AnyTypeKind.USER -> this.buildUserHandler();
                    case AnyTypeKind.GROUP -> this.buildGroupHandler();
                    default -> this.buildAnyObjectHandler();
                };
                handler.setProfile(this.profile);
                return handler;
            });
            HashSet moreAttrsToGet = new HashSet();
            this.profile.getActions().forEach(a -> moreAttrsToGet.addAll(a.moreAttrsToGet(this.profile, provision2)));
            OperationOptions options = MappingUtils.buildOperationOptions(MappingUtils.getInboundItems(provision2.getMapping().getItems().stream()), (String[])moreAttrsToGet.toArray(String[]::new));
            this.infos.add(new LiveSyncInfo(provision2, null, new ObjectClass(provision2.getObjectClass()), anyType.getKind(), uidOnCreate, options));
            Optional.ofNullable(provision2.getSyncToken()).ifPresent(syncToken -> this.setLatestSyncToken(provision2.getObjectClass(), ConnObjectUtils.toSyncToken(syncToken)));
        }
        this.setStatus("Initialization completed");
    }

    public void stop() {
        this.stopRequested = true;
    }

    @Override
    @Transactional
    public void execute(TaskType taskType, String taskKey, JobExecutionContext context) throws JobExecutionException {
        this.init(taskType, taskKey, context);
        this.setStatus("Initialization completed");
        this.doExecute(context);
        this.end();
    }

    protected boolean syncTokenChanged(String fromProvision, String objectClass) {
        return this.latestSyncTokens.containsKey(objectClass) && !Objects.equals(fromProvision, ConnObjectUtils.toString((SyncToken)this.latestSyncTokens.get(objectClass)));
    }

    protected void doLivesync() throws JobExecutionException {
        OpEvent.Outcome result;
        String status;
        String message;
        this.profile.getResults().clear();
        TaskExec<SchedTask> execution = this.initExecution();
        execution.setTask(null);
        try {
            if (!this.profile.isDryRun()) {
                for (InboundActions action : this.profile.getActions()) {
                    action.beforeAll(this.profile);
                }
            }
            this.infos.forEach(info -> {
                this.setStatus("Live syncing " + info.objectClass().getObjectClassValue());
                OperationOptions options = Optional.ofNullable((SyncToken)this.latestSyncTokens.get(info.objectClass().getObjectClassValue())).map(syncToken -> new OperationOptionsBuilder(info.options()).setPagedResultsCookie(syncToken.getValue().toString()).build()).orElseGet(() -> info.options());
                this.profile.getConnector().livesync(info.objectClass(), liveSyncDelta -> {
                    try {
                        LOG.debug("LiveSyncDelta: {}", (Object)liveSyncDelta);
                        SyncDelta syncDelta = info.provision() == null ? this.mapper.map(liveSyncDelta, info.orgUnit()) : this.mapper.map(liveSyncDelta, info.provision());
                        LOG.debug("Mapped SyncDelta: {}", (Object)syncDelta);
                        return this.dispatcher.handle(syncDelta);
                    }
                    catch (Exception e) {
                        LOG.error("While live syncing from {} with {}", new Object[]{((LiveSyncTask)this.task).getResource().getKey(), liveSyncDelta, e});
                        return false;
                    }
                }, options);
                if (info.provision() != null && info.uidOnCreate() != null) {
                    AnyUtils anyUtils = this.anyUtilsFactory.getInstance(info.anyTypeKind());
                    this.profile.getResults().stream().filter(r -> r.getUidValue() != null && r.getKey() != null && r.getOperation() == ResourceOperation.CREATE && r.getAnyType().equals(info.provision().getAnyType())).forEach(r -> this.liveSyncTaskSaver.addAttr(anyUtils, this.validator, r.getKey(), info.uidOnCreate(), r.getUidValue()));
                }
            });
            if (!this.profile.isDryRun()) {
                for (InboundActions action : this.profile.getActions()) {
                    action.afterAll(this.profile);
                }
            }
            message = this.createReport(this.profile.getResults(), ((LiveSyncTask)this.task).getResource(), this.profile.isDryRun());
            status = TaskJob.Status.SUCCESS.name();
            result = OpEvent.Outcome.SUCCESS;
        }
        catch (Throwable t) {
            LOG.error("While executing task {}", (Object)((LiveSyncTask)this.task).getKey(), (Object)t);
            message = ExceptionUtils2.getFullStackTrace((Throwable)t);
            status = TaskJob.Status.FAILURE.name();
            result = OpEvent.Outcome.FAILURE;
        }
        if (!this.profile.getResults().isEmpty()) {
            this.liveSyncTaskSaver.save(((LiveSyncTask)this.task).getKey(), execution, message, status, result, this::hasToBeRegistered);
        }
        if (!this.profile.isDryRun()) {
            boolean anySyncTokenChanged = false;
            for (int i = 0; i < this.infos.size() && !anySyncTokenChanged; ++i) {
                if (this.infos.get(i).provision() != null) {
                    anySyncTokenChanged = this.syncTokenChanged(this.infos.get(i).provision().getSyncToken(), this.infos.get(i).objectClass().getObjectClassValue());
                    continue;
                }
                if (this.infos.get(i).orgUnit() == null) continue;
                anySyncTokenChanged = this.syncTokenChanged(this.infos.get(i).orgUnit().getSyncToken(), this.infos.get(i).objectClass().getObjectClassValue());
            }
            if (anySyncTokenChanged) {
                this.liveSyncTaskSaver.save(((LiveSyncTask)this.task).getResource().getKey(), this.latestSyncTokens);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doExecute(JobExecutionContext context) throws JobExecutionException {
        Object lock;
        if (this.infos.isEmpty()) {
            LOG.info("Nothing to live sync on, aborting...");
            return "";
        }
        LOG.debug("Executing live sync on {}", (Object)((LiveSyncTask)this.task).getResource());
        Object object = lock = new Object();
        synchronized (object) {
            while (true) {
                if (this.stopRequested) {
                    // MONITOREXIT @DISABLED, blocks:[4, 9, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.dispatcher.stop();
                    this.dispatcher.shutdown();
                    return "";
                }
                try {
                    this.doLivesync();
                    continue;
                }
                finally {
                    try {
                        lock.wait(this.delaySecondsAcrossInvocations * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }

    protected record LiveSyncInfo(Provision provision, OrgUnit orgUnit, ObjectClass objectClass, AnyTypeKind anyTypeKind, PlainSchema uidOnCreate, OperationOptions options) {
    }
}

