/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.db.EntityToTableMap;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetTableNameCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> entityClass;
    protected boolean withPrefix = true;

    public GetTableNameCmd(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public GetTableNameCmd(Class<?> entityClass, boolean withPrefix) {
        this.entityClass = entityClass;
        this.withPrefix = withPrefix;
    }

    public String execute(CommandContext commandContext) {
        if (this.entityClass == null) {
            throw new FlowableIllegalArgumentException("entityClass is null");
        }
        String databaseTablePrefix = CommandContextUtil.getDbSqlSession(commandContext).getDbSqlSessionFactory().getDatabaseTablePrefix();
        String tableName = EntityToTableMap.getTableName(this.entityClass);
        if (this.withPrefix) {
            return databaseTablePrefix + tableName;
        }
        return tableName;
    }
}

