/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantRoutingFilter
implements Filter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantRoutingFilter.class);
    private final TenantExtractor tenantExtractor;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String servletPath = Strings.CI.prependIfMissing(request.getServletPath(), (CharSequence)"/", new CharSequence[0]);
        if (TenantRoutingFilter.isValidServletPath(servletPath)) {
            List tenantDefinitions = this.tenantExtractor.getTenantsManager().findTenants();
            for (TenantDefinition tenantDefinition : tenantDefinitions) {
                ConfigurationPropertiesBindingContext bindingContext = tenantDefinition.bindProperties();
                if (!bindingContext.isBound()) continue;
                String tenantHostname = TenantRoutingFilter.extractTenantHost((ConfigurationPropertiesBindingContext<CasConfigurationProperties>)bindingContext);
                if (!Strings.CI.equals(request.getServerName(), tenantHostname)) continue;
                String dispatch = "/tenants/" + tenantDefinition.getId() + servletPath;
                LOGGER.info("Routing request [{}] to tenant [{}] at [{}]", new Object[]{request.getRequestURI(), tenantDefinition.getId(), dispatch});
                RequestDispatcher dispatcher = request.getRequestDispatcher(dispatch);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private static String extractTenantHost(ConfigurationPropertiesBindingContext<CasConfigurationProperties> bindingContext) {
        if (bindingContext.containsBindingFor("cas.server.name")) {
            return (String)FunctionUtils.doUnchecked(() -> {
                String serverName = ((CasConfigurationProperties)bindingContext.value()).getServer().getName();
                return new URI(serverName).getHost();
            });
        }
        if (bindingContext.containsBindingFor("cas.host.name")) {
            return ((CasConfigurationProperties)bindingContext.value()).getHost().getName();
        }
        return null;
    }

    private static boolean isValidServletPath(String flowId) {
        return !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"/webjars/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"/css/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"/favicon") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"/images/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"/js/");
    }

    @Generated
    public TenantRoutingFilter(TenantExtractor tenantExtractor) {
        this.tenantExtractor = tenantExtractor;
    }
}

