/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerChain;
import org.opensaml.messaging.handler.MessageHandlerException;

public class BasicMessageHandlerChain
extends AbstractMessageHandler
implements MessageHandlerChain {
    @NonnullAfterInit
    private List<MessageHandler> members;

    @NonnullAfterInit
    @Unmodifiable
    @NotLive
    public List<MessageHandler> getHandlers() {
        return this.members;
    }

    public void setHandlers(@Nullable List<MessageHandler> handlers) {
        this.members = handlers != null ? CollectionSupport.copyToList(handlers) : CollectionSupport.emptyList();
    }

    public void doInvoke(@Nonnull MessageContext msgContext) throws MessageHandlerException {
        if (this.members != null) {
            for (MessageHandler handler : this.members) {
                handler.invoke(msgContext);
            }
        }
    }
}

