/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.search;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.apache.syncope.common.lib.search.SearchableFields;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.AuxClassCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;

public class SearchCondVisitor
extends AbstractSearchConditionVisitor<SearchBean, SearchCond> {
    protected static final ThreadLocal<String> REALM = new ThreadLocal();
    protected static final ThreadLocal<SearchCond> SEARCH_COND = new ThreadLocal();

    public SearchCondVisitor() {
        super(null);
    }

    public void setRealm(String realm) {
        REALM.set(realm);
    }

    protected static AttrCond createAttrCond(String schema) {
        AttrCond attrCond = SearchableFields.contains((String)schema) ? new AnyCond() : new AttrCond();
        attrCond.setSchema(schema);
        return attrCond;
    }

    protected static String getValue(SearchCondition<SearchBean> sc) {
        String value = SearchUtils.toSqlWildcardString((String)URLDecoder.decode(sc.getStatement().getValue().toString().replace("+", "%2B"), StandardCharsets.UTF_8), (boolean)false);
        if (value.indexOf(37) == -1) {
            value = value.replaceAll("\\\\_", "_");
        }
        return value;
    }

    protected static ConditionType getConditionType(SearchCondition<SearchBean> sc) {
        ConditionType ct = sc.getConditionType();
        if (sc instanceof SyncopeFiqlSearchCondition) {
            SyncopeFiqlSearchCondition sfsc = (SyncopeFiqlSearchCondition)sc;
            if (sc.getConditionType() == ConditionType.CUSTOM) {
                switch (sfsc.getOperator()) {
                    case "=~": {
                        ct = ConditionType.EQUALS;
                        break;
                    }
                    case "!~": {
                        ct = ConditionType.NOT_EQUALS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Condition type %s is not supported", sfsc.getOperator()));
                    }
                }
            }
        }
        return ct;
    }

    protected SearchCond visitPrimitive(SearchCondition<SearchBean> sc) {
        Optional<AttrCond> reprocess;
        SearchCond leaf;
        String name = this.getRealPropertyName(sc.getStatement().getProperty());
        Optional specialAttrName = SpecialAttr.fromString((String)name);
        String value = SearchCondVisitor.getValue(sc);
        Optional specialAttrValue = SpecialAttr.fromString((String)value);
        AttrCond attrCond = SearchCondVisitor.createAttrCond(name);
        attrCond.setExpression(value);
        ConditionType ct = SearchCondVisitor.getConditionType(sc);
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                if (specialAttrName.isEmpty()) {
                    if (specialAttrValue.isPresent() && specialAttrValue.get() == SpecialAttr.NULL) {
                        attrCond.setType(AttrCond.Type.ISNULL);
                        attrCond.setExpression(null);
                    } else if (value.indexOf(37) == -1) {
                        attrCond.setType(sc.getConditionType() == ConditionType.CUSTOM ? AttrCond.Type.IEQ : AttrCond.Type.EQ);
                    } else {
                        attrCond.setType(sc.getConditionType() == ConditionType.CUSTOM ? AttrCond.Type.ILIKE : AttrCond.Type.LIKE);
                    }
                    leaf = SearchCond.of(attrCond);
                } else {
                    switch ((SpecialAttr)specialAttrName.get()) {
                        case TYPE: {
                            AnyTypeCond typeCond = new AnyTypeCond();
                            typeCond.setAnyTypeKey(value);
                            leaf = SearchCond.of(typeCond);
                            break;
                        }
                        case AUX_CLASSES: {
                            AuxClassCond auxClassCond = new AuxClassCond();
                            auxClassCond.setAuxClass(value);
                            leaf = SearchCond.of(auxClassCond);
                            break;
                        }
                        case RESOURCES: {
                            ResourceCond resourceCond = new ResourceCond();
                            resourceCond.setResource(value);
                            leaf = SearchCond.of(resourceCond);
                            break;
                        }
                        case GROUPS: {
                            MembershipCond groupCond = new MembershipCond();
                            groupCond.setGroup(value);
                            leaf = SearchCond.of(groupCond);
                            break;
                        }
                        case RELATIONSHIPS: {
                            RelationshipCond relationshipCond = new RelationshipCond();
                            relationshipCond.setAnyObject(value);
                            leaf = SearchCond.of(relationshipCond);
                            break;
                        }
                        case RELATIONSHIP_TYPES: {
                            RelationshipTypeCond relationshipTypeCond = new RelationshipTypeCond();
                            relationshipTypeCond.setRelationshipType(value);
                            leaf = SearchCond.of(relationshipTypeCond);
                            break;
                        }
                        case ROLES: {
                            RoleCond roleCond = new RoleCond();
                            roleCond.setRole(value);
                            leaf = SearchCond.of(roleCond);
                            break;
                        }
                        case MEMBER: {
                            MemberCond memberCond = new MemberCond();
                            memberCond.setMember(value);
                            leaf = SearchCond.of(memberCond);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("Special attr name %s is not supported", specialAttrName));
                        }
                    }
                }
                if (ct != ConditionType.NOT_EQUALS) break;
                Optional<AttrCond> notEquals = leaf.asLeaf(AttrCond.class);
                if (notEquals.isPresent() && notEquals.get().getType() == AttrCond.Type.ISNULL) {
                    notEquals.get().setType(AttrCond.Type.ISNOTNULL);
                    break;
                }
                leaf = SearchCond.negate(leaf);
                break;
            }
            case GREATER_OR_EQUALS: {
                attrCond.setType(AttrCond.Type.GE);
                leaf = SearchCond.of(attrCond);
                break;
            }
            case GREATER_THAN: {
                attrCond.setType(AttrCond.Type.GT);
                leaf = SearchCond.of(attrCond);
                break;
            }
            case LESS_OR_EQUALS: {
                attrCond.setType(AttrCond.Type.LE);
                leaf = SearchCond.of(attrCond);
                break;
            }
            case LESS_THAN: {
                attrCond.setType(AttrCond.Type.LT);
                leaf = SearchCond.of(attrCond);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Condition type %s is not supported", ct.name()));
            }
        }
        if ((reprocess = leaf.asLeaf(AttrCond.class).filter(cond -> "token".equals(cond.getSchema()) && (cond.getType() == AttrCond.Type.ISNULL || cond.getType() == AttrCond.Type.ISNOTNULL) && cond.getExpression() == null)).isPresent()) {
            AnyCond tokenCond = new AnyCond();
            tokenCond.setSchema(reprocess.get().getSchema());
            tokenCond.setType(reprocess.get().getType());
            tokenCond.setExpression(null);
            leaf = SearchCond.of(tokenCond);
        }
        return leaf;
    }

    protected SearchCond visitCompound(SearchCondition<SearchBean> sc) {
        ArrayList<SearchCond> searchConds = new ArrayList<SearchCond>();
        sc.getSearchConditions().forEach(searchCond -> searchConds.add(searchCond.getStatement() == null ? this.visitCompound((SearchCondition<SearchBean>)searchCond) : this.visitPrimitive((SearchCondition<SearchBean>)searchCond)));
        return switch (sc.getConditionType()) {
            case ConditionType.AND -> SearchCond.and(searchConds);
            case ConditionType.OR -> SearchCond.or(searchConds);
            default -> throw new IllegalArgumentException(String.format("Condition type %s is not supported", sc.getConditionType().name()));
        };
    }

    public void visit(SearchCondition<SearchBean> sc) {
        SEARCH_COND.set(sc.getStatement() == null ? this.visitCompound(sc) : this.visitPrimitive(sc));
    }

    public SearchCond getQuery() {
        return SEARCH_COND.get();
    }
}

