/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.batch.BatchModal;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.UserRequestsPanel;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.client.ui.commons.markup.html.form.ConfirmBehavior;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class UserRequestDirectoryPanel
extends DirectoryPanel<UserRequest, UserRequest, UserRequestProvider, UserRequestRestClient> {
    private static final long serialVersionUID = -5346161040211617763L;
    private static final String PREF_USER_REQUEST_PAGINATOR_ROWS = "userrequest.paginator.rows";
    private String keyword;

    public UserRequestDirectoryPanel(String id, final UserRequestRestClient restClient, final PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, true);
        this.setFooterVisibility(false);
        this.initResultTable();
        IndicatingAjaxButton batchLink = new IndicatingAjaxButton(this, "batchLink", this.resultTable.group.getForm()){
            private static final long serialVersionUID = 382302811235019988L;
            final /* synthetic */ UserRequestDirectoryPanel this$0;
            {
                this.this$0 = this$0;
                super(id, form);
            }

            public void onSubmit(AjaxRequestTarget target) {
                Collection items = (Collection)this.this$0.resultTable.group.getModelObject();
                if (!items.isEmpty()) {
                    BatchRequest batch = SyncopeConsoleSession.get().batch();
                    UserRequestService service = (UserRequestService)batch.getService(UserRequestService.class);
                    items.forEach(item -> service.cancelRequest(item.getExecutionId(), null));
                    Map<String, String> results = restClient.batch(batch);
                    this.this$0.resultTable.batchModal.header((IModel)new ResourceModel("batch"));
                    this.this$0.resultTable.batchModal.changeCloseButtonLabel(this.getString("cancel", null, "Cancel"), target);
                    target.add(new Component[]{this.this$0.resultTable.batchModal.setContent((ModalPanel)new BatchModal(this.this$0.resultTable.batchModal, pageRef, new ArrayList(items), this.this$0.getColumns(), results, "executionId", target))});
                    this.this$0.resultTable.batchModal.show(true);
                }
            }
        };
        batchLink.add(new Behavior[]{new ConfirmBehavior((Component)batchLink, "confirmDelete")});
        ((WebMarkupContainer)this.resultTable.get("tablePanel")).addOrReplace(new Component[]{batchLink});
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"USER_REQUEST_LIST");
    }

    protected List<IColumn<UserRequest, String>> getColumns() {
        ArrayList<IColumn<UserRequest, String>> columns = new ArrayList<IColumn<UserRequest, String>>();
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("bpmnProcess"), (Object)"bpmnProcess", "bpmnProcess"));
        columns.add((IColumn<UserRequest, String>)new DatePropertyColumn((IModel)new ResourceModel("startTime"), "startTime", "startTime"));
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("username"), "username"));
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("activityId"), "activityId"));
        return columns;
    }

    public ActionsPanel<UserRequest> getActions(final IModel<UserRequest> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<UserRequest>(this){
            private static final long serialVersionUID = -3722207913631435501L;
            final /* synthetic */ UserRequestDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, UserRequest ignore) {
                try {
                    ((UserRequestRestClient)this.this$0.restClient).cancelRequest(((UserRequest)model.getObject()).getExecutionId(), null);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                    target.add(new Component[]{this.this$0.container});
                    this.this$0.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While canceling execution {}", (Object)((UserRequest)model.getObject()).getExecutionId(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "USER_REQUEST_CANCEL", true);
        return panel;
    }

    protected UserRequestProvider dataProvider() {
        return new UserRequestProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_USER_REQUEST_PAGINATOR_ROWS;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof UserRequestsPanel.UserRequestSearchEvent) {
            UserRequestsPanel.UserRequestSearchEvent payload = (UserRequestsPanel.UserRequestSearchEvent)object;
            this.keyword = payload.getKeyword();
            this.updateResultTable(payload.getTarget());
        } else {
            super.onEvent(event);
        }
    }

    protected final class UserRequestProvider
    extends DirectoryDataProvider<UserRequest> {
        private static final long serialVersionUID = -1392420250782313734L;

        public UserRequestProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("startTime", SortOrder.ASCENDING);
        }

        public Iterator<UserRequest> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((UserRequestRestClient)UserRequestDirectoryPanel.this.restClient).listRequests(UserRequestDirectoryPanel.this.keyword, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return ((UserRequestRestClient)UserRequestDirectoryPanel.this.restClient).countRequests(UserRequestDirectoryPanel.this.keyword);
        }

        public IModel<UserRequest> model(UserRequest request) {
            return Model.of((Serializable)request);
        }
    }
}

