/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.metadata;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="samlIdPMetadataController")
@Tag(name="SAML2")
public class SamlIdPMetadataController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPMetadataController.class);
    private static final String CONTENT_TYPE = "text/xml;charset=UTF-8";
    private final SamlIdPMetadataGenerator metadataAndCertificatesGenerationService;
    private final SamlIdPMetadataLocator samlIdPMetadataLocator;
    private final ServicesManager servicesManager;
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;

    @Operation(summary="Generate IdP metadata", parameters={@Parameter(name="service", in=ParameterIn.QUERY, required=false, description="Service identifier")})
    @GetMapping(path={"/idp/metadata"}, produces={"text/xml;charset=UTF-8"})
    public void generateMetadataForIdp(@RequestParam(value="service", required=false) String service, HttpServletResponse response) throws Throwable {
        Optional<SamlRegisteredService> registeredService = this.getRegisteredServiceIfAny(service);
        this.metadataAndCertificatesGenerationService.generate(registeredService);
        response.setContentType(CONTENT_TYPE);
        response.setStatus(200);
        try (InputStream md = this.samlIdPMetadataLocator.resolveMetadata(registeredService).getInputStream();){
            String contents = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
            try (PrintWriter writer = response.getWriter();){
                LOGGER.debug("Producing metadata for the response");
                writer.write(contents);
                writer.flush();
            }
        }
    }

    @GetMapping(path={"/idp/metadata/signingCertificate"}, produces={"text/plain"})
    @Operation(summary="Get IdP signing certificate", parameters={@Parameter(name="service", in=ParameterIn.QUERY, required=false, description="Service identifier")})
    public String idpSigningCertificate(@RequestParam(value="service", required=false) String service) throws Throwable {
        Optional<SamlRegisteredService> registeredService = this.getRegisteredServiceIfAny(service);
        this.metadataAndCertificatesGenerationService.generate(registeredService);
        try (InputStream md = this.samlIdPMetadataLocator.resolveSigningCertificate(registeredService).getInputStream();){
            String string = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Operation(summary="Get IdP encryption certificate", parameters={@Parameter(name="service", in=ParameterIn.QUERY, required=false, description="Service identifier")})
    @GetMapping(path={"/idp/metadata/encryptionCertificate"}, produces={"text/plain"})
    public String idpEncryptionCertificate(@RequestParam(value="service", required=false) String service) throws Throwable {
        Optional<SamlRegisteredService> registeredService = this.getRegisteredServiceIfAny(service);
        this.metadataAndCertificatesGenerationService.generate(registeredService);
        try (InputStream md = this.samlIdPMetadataLocator.resolveEncryptionCertificate(registeredService).getInputStream();){
            String string = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private Optional<SamlRegisteredService> getRegisteredServiceIfAny(String service) {
        if (NumberUtils.isDigits((String)service)) {
            SamlRegisteredService svc = (SamlRegisteredService)this.servicesManager.findServiceBy(Long.parseLong(service), SamlRegisteredService.class);
            return Optional.ofNullable(svc);
        }
        WebApplicationService svc = StringUtils.isNotBlank((CharSequence)service) ? (WebApplicationService)this.webApplicationServiceFactory.createService(service) : null;
        SamlRegisteredService registeredService = (SamlRegisteredService)this.servicesManager.findServiceBy((Service)svc, SamlRegisteredService.class);
        return Optional.ofNullable(registeredService);
    }

    @Generated
    public SamlIdPMetadataController(SamlIdPMetadataGenerator metadataAndCertificatesGenerationService, SamlIdPMetadataLocator samlIdPMetadataLocator, ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceFactory) {
        this.metadataAndCertificatesGenerationService = metadataAndCertificatesGenerationService;
        this.samlIdPMetadataLocator = samlIdPMetadataLocator;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }
}

