/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPHttpRedirectDeflateEncoder
extends HTTPRedirectDeflateEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPHttpRedirectDeflateEncoder.class);
    private final String endpointUrl;
    private final SignableXMLObject request;
    private String redirectUrl;
    private MessageContext messageContext;
    private String encodedRequest;
    private String relayState;

    public void doEncode() throws MessageEncodingException {
        this.messageContext = new MessageContext();
        if (this.request.isSigned()) {
            LOGGER.trace("Request is signed for [{}]", (Object)this.request.getElementQName());
            SecurityParametersContext signingContext = (SecurityParametersContext)this.messageContext.ensureSubcontext(SecurityParametersContext.class);
            SignatureSigningParameters signingParams = new SignatureSigningParameters();
            Signature signature = this.request.getSignature();
            signingParams.setSigningCredential(Objects.requireNonNull(signature).getSigningCredential());
            signingParams.setSignatureAlgorithm(signature.getSignatureAlgorithm());
            Objects.requireNonNull(signingContext).setSignatureSigningParameters(signingParams);
        }
        SAMLObject samlObject = (SAMLObject)this.request;
        this.removeSignature(samlObject);
        this.encodedRequest = this.deflateAndBase64Encode(samlObject);
        this.messageContext.setMessage((Object)this.request);
        FunctionUtils.doIfNotNull((Object)this.relayState, value -> SAMLBindingSupport.setRelayState((MessageContext)this.messageContext, (String)value));
        this.redirectUrl = this.buildRedirectURL(this.messageContext, this.endpointUrl, this.encodedRequest);
        LOGGER.debug("Created redirect URL [{}] based on endpoint [{}]", (Object)this.redirectUrl, (Object)this.endpointUrl);
    }

    protected void doInitialize() {
    }

    @Generated
    public SamlIdPHttpRedirectDeflateEncoder(String endpointUrl, SignableXMLObject request) {
        this.endpointUrl = endpointUrl;
        this.request = request;
    }

    @Generated
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Generated
    public SignableXMLObject getRequest() {
        return this.request;
    }

    @Generated
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Generated
    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Generated
    public String getEncodedRequest() {
        return this.encodedRequest;
    }

    @Generated
    public String getRelayState() {
        return this.relayState;
    }

    @Generated
    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }
}

