/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class X509CertificateMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String X509_CERTIFICATE_MONITOR_OC = "ds-x509-certificate-monitor-entry";
    @NotNull
    private static final String ATTR_ALIAS = "alias";
    @NotNull
    private static final String ATTR_COMPONENT_NAME = "component-name";
    @NotNull
    private static final String ATTR_COMPONENT_TYPE = "component-type";
    @NotNull
    private static final String ATTR_CONTEXT_TYPE = "context-type";
    @NotNull
    private static final String ATTR_CURRENTLY_VALID = "currently-valid";
    @NotNull
    private static final String ATTR_DEPENDENT_COMPONENT = "dependent-component";
    @NotNull
    private static final String ATTR_HUMAN_READABLE_TIME_UNTIL_EXPIRATION = "expires";
    @NotNull
    private static final String ATTR_INVALID_REASON = "invalid-reason";
    @NotNull
    private static final String ATTR_ISSUER_SUBJECT_DN = "issuer";
    @NotNull
    private static final String ATTR_KEY_STORE_FILE = "keystore-file";
    @NotNull
    private static final String ATTR_KEY_STORE_TYPE = "keystore-type";
    @NotNull
    private static final String ATTR_NOT_VALID_AFTER = "not-valid-after";
    @NotNull
    private static final String ATTR_NOT_VALID_BEFORE = "not-valid-before";
    @NotNull
    private static final String ATTR_PROPERTY = "property";
    @NotNull
    private static final String ATTR_PROVIDER_TYPE = "provider-type";
    @NotNull
    private static final String ATTR_SECONDS_UNTIL_EXPIRATION = "expires-seconds";
    @NotNull
    private static final String ATTR_SERIAL_NUMBER = "serial-number";
    @NotNull
    private static final String ATTR_SUBJECT_DN = "subject";
    private static final long serialVersionUID = -750858825553972559L;
    @Nullable
    private final Boolean currentlyValid;
    @Nullable
    private final Date notValidAfter;
    @Nullable
    private final Date notValidBefore;
    @NotNull
    private final List<String> dependentComponents;
    @NotNull
    private final List<String> properties;
    @Nullable
    private final Long secondsUntilExpiration;
    @Nullable
    private final String alias;
    @Nullable
    private final String componentName;
    @Nullable
    private final String componentType;
    @Nullable
    private final String contextType;
    @Nullable
    private final String humanReadableTimeUntilExpiration;
    @Nullable
    private final String invalidReason;
    @Nullable
    private final String issuerSubjectDN;
    @Nullable
    private final String keyStoreFile;
    @Nullable
    private final String keyStoreType;
    @Nullable
    private final String providerType;
    @Nullable
    private final String serialNumber;
    @Nullable
    private final String subjectDN = this.getString("subject");

    public X509CertificateMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.issuerSubjectDN = this.getString(ATTR_ISSUER_SUBJECT_DN);
        this.notValidBefore = this.getDate(ATTR_NOT_VALID_BEFORE);
        this.notValidAfter = this.getDate(ATTR_NOT_VALID_AFTER);
        this.secondsUntilExpiration = this.getLong(ATTR_SECONDS_UNTIL_EXPIRATION);
        this.humanReadableTimeUntilExpiration = this.getString(ATTR_HUMAN_READABLE_TIME_UNTIL_EXPIRATION);
        this.currentlyValid = this.getBoolean(ATTR_CURRENTLY_VALID);
        this.invalidReason = this.getString(ATTR_INVALID_REASON);
        this.serialNumber = this.getString(ATTR_SERIAL_NUMBER);
        this.contextType = this.getString(ATTR_CONTEXT_TYPE);
        this.componentType = this.getString(ATTR_COMPONENT_TYPE);
        this.componentName = this.getString(ATTR_COMPONENT_NAME);
        this.keyStoreType = this.getString(ATTR_KEY_STORE_TYPE);
        this.keyStoreFile = this.getString(ATTR_KEY_STORE_FILE);
        this.alias = this.getString(ATTR_ALIAS);
        this.providerType = this.getString(ATTR_PROVIDER_TYPE);
        this.dependentComponents = this.getStrings(ATTR_DEPENDENT_COMPONENT);
        this.properties = this.getStrings(ATTR_PROPERTY);
    }

    @Nullable
    public String getSubjectDN() {
        return this.subjectDN;
    }

    @Nullable
    public String getIssuerSubjectDN() {
        return this.issuerSubjectDN;
    }

    @Nullable
    public Date getNotValidBefore() {
        return this.notValidBefore;
    }

    @Nullable
    public Date getNotValidAfter() {
        return this.notValidAfter;
    }

    @Nullable
    public Long getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Nullable
    public String getHumanReadableTimeUntilExpiration() {
        return this.humanReadableTimeUntilExpiration;
    }

    @Nullable
    public Boolean getCurrentlyValid() {
        return this.currentlyValid;
    }

    @Nullable
    public String getInvalidReason() {
        return this.invalidReason;
    }

    @Nullable
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Nullable
    public String getContextType() {
        return this.contextType;
    }

    @Nullable
    public String getComponentType() {
        return this.componentType;
    }

    @Nullable
    public String getComponentName() {
        return this.componentName;
    }

    @Nullable
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Nullable
    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public String getProviderType() {
        return this.providerType;
    }

    @NotNull
    public List<String> getDependentComponents() {
        return this.dependentComponents;
    }

    @NotNull
    public List<String> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_X509_CERTIFICATE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_X509_CERTIFICATE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.subjectDN != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_SUBJECT_DN, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_SUBJECT_DN.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_SUBJECT_DN.get(), this.subjectDN);
        }
        if (this.issuerSubjectDN != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_ISSUER_SUBJECT_DN, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_ISSUER_DN.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_ISSUER_DN.get(), this.issuerSubjectDN);
        }
        if (this.notValidBefore != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_NOT_VALID_BEFORE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_NOT_BEFORE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_NOT_BEFORE.get(), this.notValidBefore);
        }
        if (this.notValidAfter != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_NOT_VALID_AFTER, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_NOT_AFTER.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_NOT_AFTER.get(), this.notValidAfter);
        }
        if (this.secondsUntilExpiration != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_SECONDS_UNTIL_EXPIRATION, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_SECONDS_UNTIL_EXPIRATION.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_SECONDS_UNTIL_EXPIRATION.get(), this.secondsUntilExpiration);
        }
        if (this.humanReadableTimeUntilExpiration != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_HUMAN_READABLE_TIME_UNTIL_EXPIRATION, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_TIME_UNTIL_EXPIRATION.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_TIME_UNTIL_EXPIRATION.get(), this.humanReadableTimeUntilExpiration);
        }
        if (this.currentlyValid != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENTLY_VALID, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_CURRENTLY_VALID.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_CURRENTLY_VALID.get(), this.currentlyValid);
        }
        if (this.invalidReason != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_INVALID_REASON, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_INVALID_REASON.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_INVALID_REASON.get(), this.invalidReason);
        }
        if (this.serialNumber != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_SERIAL_NUMBER, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_SERIAL_NUMBER.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_SERIAL_NUMBER.get(), this.serialNumber);
        }
        if (this.contextType != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_CONTEXT_TYPE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_CONTEXT_TYPE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_CONTEXT_TYPE.get(), this.contextType);
        }
        if (this.componentType != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPONENT_TYPE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_COMPONENT_TYPE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_COMPONENT_TYPE.get(), this.componentType);
        }
        if (this.componentName != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPONENT_NAME, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_COMPONENT_NAME.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_COMPONENT_NAME.get(), this.componentName);
        }
        if (this.keyStoreType != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_KEY_STORE_TYPE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_KEY_STORE_TYPE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_KEY_STORE_TYPE.get(), this.keyStoreType);
        }
        if (this.keyStoreFile != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_KEY_STORE_FILE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_KEY_STORE_FILE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_KEY_STORE_FILE.get(), this.keyStoreFile);
        }
        if (this.alias != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_ALIAS, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_ALIAS.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_ALIAS.get(), this.alias);
        }
        if (this.providerType != null) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_PROVIDER_TYPE, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_PROVIDER_TYPE.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_PROVIDER_TYPE.get(), this.providerType);
        }
        if (!this.dependentComponents.isEmpty()) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_DEPENDENT_COMPONENT, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_DEPENDENT_COMPONENT.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_DEPENDENT_COMPONENT.get(), this.dependentComponents);
        }
        if (!this.properties.isEmpty()) {
            X509CertificateMonitorEntry.addMonitorAttribute(attrs, ATTR_PROPERTY, MonitorMessages.INFO_X509_CERTIFICATE_DISPNAME_PROPERTY.get(), MonitorMessages.INFO_X509_CERTIFICATE_DESC_PROPERTY.get(), this.properties);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

