/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.dao.AuditEventDAO;
import org.apache.syncope.core.persistence.api.entity.AuditEvent;
import org.apache.syncope.core.persistence.jpa.entity.JPAAuditEvent;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public class JPAAuditEventDAO
implements AuditEventDAO {
    protected final EntityManager entityManager;

    public JPAAuditEventDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional
    public AuditEvent save(AuditEvent auditEvent) {
        return (AuditEvent)this.entityManager.merge((Object)auditEvent);
    }

    protected AuditEventCriteriaBuilder criteriaBuilder(String entityKey) {
        return new AuditEventCriteriaBuilder().entityKey(entityKey);
    }

    protected void fillWithParameters(Query query, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object object = parameters.get(i);
            if (object instanceof Boolean) {
                Boolean aBoolean = (Boolean)object;
                query.setParameter(i + 1, (Object)(aBoolean != false ? 1 : 0));
                continue;
            }
            query.setParameter(i + 1, parameters.get(i));
        }
    }

    @Transactional(readOnly=true)
    public long count(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, OffsetDateTime before, OffsetDateTime after) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String queryString = "SELECT COUNT(0) FROM AuditEvent WHERE" + this.criteriaBuilder(entityKey).opEvent(type, category, subcategory, op, outcome).before(before, parameters).after(after, parameters).build();
        Query query = this.entityManager.createNativeQuery(queryString);
        this.fillWithParameters(query, parameters);
        return ((Number)query.getSingleResult()).longValue();
    }

    @Transactional(readOnly=true)
    public List<AuditEventTO> search(String entityKey, OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String queryString = "SELECT id FROM AuditEvent WHERE" + this.criteriaBuilder(entityKey).opEvent(type, category, subcategory, op, outcome).before(before, parameters).after(after, parameters).build();
        if (!pageable.getSort().isEmpty()) {
            queryString = queryString + " ORDER BY " + pageable.getSort().stream().map(clause -> ("when".equals(clause.getProperty()) ? "event_date" : clause.getProperty()) + " " + clause.getDirection().name()).collect(Collectors.joining(","));
        }
        Query query = this.entityManager.createNativeQuery(queryString);
        this.fillWithParameters(query, parameters);
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        List entries = query.getResultList();
        return entries.stream().map(row -> (JPAAuditEvent)this.entityManager.find(JPAAuditEvent.class, (Object)row.toString())).filter(Objects::nonNull).map(arg_0 -> ((JPAAuditEventDAO)this).toAuditEventTO(arg_0)).toList();
    }

    protected static class AuditEventCriteriaBuilder {
        protected final StringBuilder query = new StringBuilder();

        protected AuditEventCriteriaBuilder() {
        }

        protected String andIfNeeded() {
            return this.query.length() == 0 ? " " : " AND ";
        }

        protected int setParameter(List<Object> parameters, Object parameter) {
            parameters.add(parameter);
            return parameters.size();
        }

        protected AuditEventCriteriaBuilder entityKey(String entityKey) {
            if (entityKey != null) {
                this.query.append(this.andIfNeeded()).append("(before_value LIKE '%\"key\":\"").append(entityKey).append("\"%' OR ").append("inputs LIKE '%\"key\":\"").append(entityKey).append("\"%' OR ").append("output LIKE '%\"key\":\"").append(entityKey).append("\"%' OR ").append("throwable LIKE '%\"key\":\"").append(entityKey).append("\"%')");
            }
            return this;
        }

        public AuditEventCriteriaBuilder opEvent(OpEvent.CategoryType type, String category, String subcategory, String op, OpEvent.Outcome outcome) {
            this.query.append(this.andIfNeeded()).append("opEvent LIKE '").append(OpEvent.toString((OpEvent.CategoryType)type, (String)category, (String)subcategory, (String)op, (OpEvent.Outcome)outcome).replace("[]", "[%]")).append("'");
            return this;
        }

        public AuditEventCriteriaBuilder before(OffsetDateTime before, List<Object> parameters) {
            if (before != null) {
                this.query.append(this.andIfNeeded()).append("event_date").append(" <= ?").append(this.setParameter(parameters, before));
            }
            return this;
        }

        public AuditEventCriteriaBuilder after(OffsetDateTime after, List<Object> parameters) {
            if (after != null) {
                this.query.append(this.andIfNeeded()).append("event_date").append(" >= ?").append(this.setParameter(parameters, after));
            }
            return this;
        }

        public String build() {
            return this.query.toString();
        }
    }
}

