/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.FIQLQueryDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractAnyRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.UserRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.AbstractAttributable;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.user.JPALinkedAccount;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class UserRepoExtImpl
extends AbstractAnyRepoExt<User>
implements UserRepoExt {
    protected final RoleDAO roleDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final GroupDAO groupDAO;
    protected final DelegationDAO delegationDAO;
    protected final FIQLQueryDAO fiqlQueryDAO;
    protected final SecurityProperties securityProperties;

    public UserRepoExtImpl(AnyUtilsFactory anyUtilsFactory, PlainSchemaDAO plainSchemaDAO, RoleDAO roleDAO, AccessTokenDAO accessTokenDAO, GroupDAO groupDAO, DelegationDAO delegationDAO, FIQLQueryDAO fiqlQueryDAO, SecurityProperties securityProperties, EntityManager entityManager, AnyFinder anyFinder) {
        super(plainSchemaDAO, entityManager, anyFinder, anyUtilsFactory.getInstance(AnyTypeKind.USER));
        this.roleDAO = roleDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.groupDAO = groupDAO;
        this.delegationDAO = delegationDAO;
        this.fiqlQueryDAO = fiqlQueryDAO;
        this.securityProperties = securityProperties;
    }

    @Override
    public boolean isManager(String key) {
        Query user = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM SyncopeUser WHERE uManager_id=?");
        user.setParameter(1, (Object)key);
        Query group = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM SyncopeGroup WHERE uManager_id=?");
        group.setParameter(1, (Object)key);
        Query anyObject = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM AnyObject WHERE uManager_id=?");
        anyObject.setParameter(1, (Object)key);
        return ((Number)user.getSingleResult()).longValue() + ((Number)group.getSingleResult()).longValue() + ((Number)anyObject.getSingleResult()).longValue() > 0L;
    }

    @Override
    public List<User> findManagedUsers(String key) {
        ArrayList result = new ArrayList();
        TypedQuery users = this.entityManager.createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE e.uManager.id=:key", User.class);
        users.setParameter("key", (Object)key);
        result.addAll(users.getResultList());
        this.findManagedGroupKeys(key).forEach(group -> this.groupDAO.findUMembers(group).forEach(member -> Optional.ofNullable((JPAUser)this.entityManager.find(JPAUser.class, member)).ifPresent(result::add)));
        Query query = this.entityManager.createNativeQuery("SELECT DISTINCT group_id FROM UMembership WHERE user_id=?");
        query.setParameter(1, (Object)key);
        List groups = query.getResultList();
        groups.stream().map(String.class::cast).forEach(group -> result.addAll(this.groupDAO.findManagedUsers(group)));
        return result.stream().distinct().toList();
    }

    protected List<String> findManagedGroupKeys(String key) {
        Query query = this.entityManager.createNativeQuery("SELECT DISTINCT id FROM SyncopeGroup WHERE uManager_id=?");
        query.setParameter(1, (Object)key);
        List result = query.getResultList();
        return result.stream().map(String.class::cast).toList();
    }

    @Override
    public List<Group> findManagedGroups(String key) {
        return this.findManagedGroupKeys(key).stream().map(group -> Optional.ofNullable((JPAGroup)this.entityManager.find(JPAGroup.class, group))).flatMap(Optional::stream).map(Group.class::cast).toList();
    }

    @Override
    public List<AnyObject> findManagedAnyObjects(String key) {
        ArrayList result = new ArrayList();
        TypedQuery anyObjects = this.entityManager.createQuery("SELECT e FROM " + JPAAnyObject.class.getSimpleName() + " e WHERE e.uManager.id=:key", AnyObject.class);
        anyObjects.setParameter("key", (Object)key);
        result.addAll(anyObjects.getResultList());
        this.findManagedGroupKeys(key).forEach(group -> this.groupDAO.findUMembers(group).forEach(member -> Optional.ofNullable((JPAAnyObject)this.entityManager.find(JPAAnyObject.class, member)).ifPresent(result::add)));
        Query query = this.entityManager.createNativeQuery("SELECT DISTINCT group_id FROM UMembership WHERE user_id=?");
        query.setParameter(1, (Object)key);
        List groups = query.getResultList();
        groups.stream().map(String.class::cast).forEach(group -> result.addAll(this.groupDAO.findManagedAnyObjects(group)));
        return result.stream().distinct().toList();
    }

    @Override
    public Map<String, Long> countByRealm() {
        Query query = this.entityManager.createQuery("SELECT e.realm, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> ((Realm)result[0]).getFullPath(), result -> ((Number)result[1]).longValue()));
    }

    @Override
    public Map<String, Long> countByStatus() {
        Query query = this.entityManager.createQuery("SELECT e.status, COUNT(e) FROM " + this.anyUtils.anyClass().getSimpleName() + " e GROUP BY e.status");
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> (String)result[0], result -> ((Number)result[1]).longValue()));
    }

    @Override
    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm, Collection<String> groups) {
        boolean authorized = authRealms.stream().map(authRealm -> RealmUtils.ManagerRealm.of((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(managerRealm -> key.equals(managerRealm.anyKey()));
        if (!authorized) {
            authorized = authRealms.stream().map(authRealm -> RealmUtils.ManagerRealm.of((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(managerRealm -> groups.contains(managerRealm.anyKey()));
        }
        if (!authorized) {
            authorized = authRealms.stream().anyMatch(realm::startsWith);
        }
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.USER.name(), key);
        }
    }

    @Override
    protected void securityChecks(User user) {
        if (!AuthContextUtils.getUsername().equals(this.securityProperties.getAnonymousUser()) && !AuthContextUtils.getUsername().equals(user.getUsername())) {
            Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault("USER_READ", Set.of());
            this.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), this.findAllGroupKeys(user));
        }
    }

    @Override
    public void deleteMembership(UMembership membership) {
        this.entityManager.remove((Object)membership);
    }

    protected User checkBeforeSave(User user) {
        User merged = user;
        if (user.getLinkedAccounts() == null) {
            this.entityManager.flush();
            merged = (User)this.entityManager.merge((Object)user);
        }
        merged.getLinkedAccounts().stream().map(JPALinkedAccount.class::cast).forEach(AbstractAttributable::list2json);
        super.checkBeforeSave((JPAUser)merged);
        merged.getLinkedAccounts().forEach(account -> super.checkBeforeSave((JPALinkedAccount)account));
        return merged;
    }

    @Override
    public <S extends User> S save(S user) {
        this.checkBeforeSave(user);
        User merged = (User)this.entityManager.merge(user);
        this.entityManager.flush();
        return (S)merged;
    }

    @Override
    public void delete(User user) {
        this.delegationDAO.findByDelegating(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.delegationDAO.findByDelegated(user).forEach(arg_0 -> ((DelegationDAO)this.delegationDAO).delete(arg_0));
        this.fiqlQueryDAO.findByOwner(user, null).forEach(arg_0 -> ((FIQLQueryDAO)this.fiqlQueryDAO).delete(arg_0));
        this.accessTokenDAO.findByOwner(user.getUsername()).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        this.entityManager.remove((Object)user);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Role> findAllRoles(User user) {
        HashSet<Role> result = new HashSet<Role>();
        result.addAll(user.getRoles());
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(User user) {
        return user.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(User user) {
        return this.findAllGroups(user).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupNames(User user) {
        return this.findAllGroups(user).stream().map(Group::getName).toList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(User user) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(user.getResources());
        this.findAllGroups(user).forEach(group -> result.addAll(group.getResources()));
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findAllResources((User)this.authFind(key)).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean linkedAccountExists(String userKey, String connObjectKeyValue) {
        Query query = this.entityManager.createNativeQuery("SELECT COUNT(id) FROM LinkedAccount WHERE owner_id=? AND connObjectKeyValue=?");
        query.setParameter(1, (Object)userKey);
        query.setParameter(2, (Object)connObjectKeyValue);
        return ((Number)query.getSingleResult()).longValue() > 0L;
    }
}

