/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceFactory<T extends Service>
implements ServiceFactory<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceFactory.class);
    private static final List<String> IGNORED_ATTRIBUTES_PARAMS = List.of("password", "service", "targetService", "ticket", "format");
    private final TenantExtractor tenantExtractor;
    private final UrlValidator urlValidator;
    private int order = Integer.MAX_VALUE;

    protected static String cleanupUrl(String url) {
        if (url == null) {
            return null;
        }
        int jsessionPosition = url.indexOf(";jsession");
        if (jsessionPosition == -1) {
            return url;
        }
        int questionMarkPosition = url.indexOf(63);
        if (questionMarkPosition < jsessionPosition) {
            return url.substring(0, url.indexOf(";jsession"));
        }
        return url.substring(0, jsessionPosition) + url.substring(questionMarkPosition);
    }

    protected static String getSourceParameter(HttpServletRequest request, String ... paramNames) {
        if (request != null) {
            Map parameterMap = request.getParameterMap();
            return Stream.of(paramNames).filter(p -> parameterMap.containsKey(p) || request.getAttribute(p) != null).findFirst().orElse(null);
        }
        return null;
    }

    protected Map<String, List> extractQueryParameters(Service service) {
        LinkedHashMap<String, List> attributes = new LinkedHashMap<String, List>();
        if (service instanceof WebApplicationService) {
            WebApplicationService webApplicationService = (WebApplicationService)service;
            String originalUrl = webApplicationService.getOriginalUrl();
            try {
                if (this.urlValidator.isValid(originalUrl)) {
                    List queryParams = (List)FunctionUtils.doUnchecked(() -> new URIBuilder(originalUrl).getQueryParams());
                    queryParams.forEach(pair -> {
                        List values = CollectionUtils.wrapArrayList((Object[])new String[]{StringEscapeUtils.escapeHtml4((String)pair.getValue())});
                        attributes.put(pair.getName(), values);
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to extract query parameters from [{}]: [{}]", (Object)originalUrl, (Object)e.getMessage());
            }
        }
        return attributes;
    }

    protected Service populateAttributes(Service service, HttpServletRequest request) {
        Map<String, ArrayList> attributes = request.getParameterMap().entrySet().stream().filter(entry -> !IGNORED_ATTRIBUTES_PARAMS.contains(entry.getKey())).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((ArrayList)CollectionUtils.toCollection(entry.getValue(), ArrayList.class)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        attributes.putAll(this.extractQueryParameters(service));
        Boolean collectAttributes = Objects.requireNonNullElse((Boolean)request.getAttribute("collectServiceAttributes"), Boolean.TRUE);
        if (collectAttributes.booleanValue()) {
            LinkedHashMap httpRequest = new LinkedHashMap();
            FunctionUtils.doIfNotBlank((CharSequence)request.getPathInfo(), value -> this.collectHttpRequestProperty("pathInfo", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getMethod(), value -> this.collectHttpRequestProperty("httpMethod", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getRequestURL(), value -> this.collectHttpRequestProperty("requestURL", value.toString(), httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getRequestURI(), value -> this.collectHttpRequestProperty("requestURI", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getRequestId(), value -> this.collectHttpRequestProperty("requestId", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getContentType(), value -> this.collectHttpRequestProperty("contentType", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getContextPath(), value -> this.collectHttpRequestProperty("contextPath", (String)value, httpRequest));
            FunctionUtils.doIfNotBlank((CharSequence)request.getLocalName(), value -> this.collectHttpRequestProperty("localeName", (String)value, httpRequest));
            if (!httpRequest.isEmpty()) {
                attributes.put("httpRequest", (ArrayList)((Object)httpRequest));
            }
            LinkedHashMap cookies = new LinkedHashMap();
            FunctionUtils.doIfNotNull((Object)request.getCookies(), __ -> Arrays.stream(request.getCookies()).forEach(cookie -> this.collectHttpRequestProperty("cookie-%s".formatted(cookie.getName()), cookie.getValue(), cookies)));
            if (!cookies.isEmpty()) {
                attributes.put("cookies", (ArrayList)((Object)cookies));
            }
            LinkedHashMap headers = new LinkedHashMap();
            FunctionUtils.doIfNotNull((Object)request.getHeaderNames(), __ -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(request.getHeaderNames().asIterator(), 16), false).forEach(header -> this.collectHttpRequestProperty("header-%s".formatted(header), request.getHeader(header), headers)));
            if (!headers.isEmpty()) {
                attributes.put("headers", (ArrayList)((Object)headers));
            }
        }
        LOGGER.trace("Extracted attributes [{}] for service [{}]", attributes, (Object)service.getId());
        service.setAttributes(attributes);
        this.tenantExtractor.extract(request).map(TenantDefinition::getId).ifPresent(arg_0 -> ((Service)service).setTenant(arg_0));
        return service;
    }

    protected void collectHttpRequestProperty(String name, String value, Map attributes) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            List entries = CollectionUtils.wrapArrayList((Object[])new String[]{StringEscapeUtils.escapeHtml4((String)value)});
            attributes.put(HttpServletRequest.class.getName() + "." + name, entries);
        }
    }

    public <T extends Service> T createService(String id, Class<T> clazz) {
        Service service = this.createService(id);
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + String.valueOf(service.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)service;
    }

    public <T extends Service> T createService(HttpServletRequest request, Class<T> clazz) {
        Service service = this.createService(request);
        if (service != null && !clazz.isAssignableFrom(service.getClass())) {
            throw new ClassCastException("Service [" + service.getId() + " is of type " + String.valueOf(service.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)service;
    }

    public T createService(String id, HttpServletRequest request) {
        Service service = this.createService(id);
        return (T)this.populateAttributes(service, request);
    }

    @Generated
    public String toString() {
        return "AbstractServiceFactory(tenantExtractor=" + String.valueOf(this.tenantExtractor) + ", urlValidator=" + String.valueOf(this.urlValidator) + ", order=" + this.order + ")";
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public UrlValidator getUrlValidator() {
        return this.urlValidator;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public AbstractServiceFactory(TenantExtractor tenantExtractor, UrlValidator urlValidator) {
        this.tenantExtractor = tenantExtractor;
        this.urlValidator = urlValidator;
    }
}

