/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mailcommons;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.utils.DateUtils;
import org.apache.tika.utils.StringUtils;

public class MailDateParser {
    private static final Pattern LOCALIZED_OFFSET_PATTERN = Pattern.compile("(?:UTC|GMT)\\s*([-+])\\s*(\\d?\\d):?(\\d\\d)?\\Z");
    private static final Pattern OFFSET_PATTERN = Pattern.compile("(?:(?:-\\d\\d-\\d{4})|([-+])\\s*(\\d?\\d):?(\\d\\d))");
    private static final Pattern DAYS_OF_WEEK = Pattern.compile("(?:\\A| )(MON|MONDAY|TUE|TUES|TUESDAY|WED|WEDNESDAY|THU|THUR|THURS|THURSDAY|FRI|FRIDAY|SAT|SATURDAY|SUN|SUNDAY) ");
    private static final Pattern AM_PM = Pattern.compile("(?i)(\\d)([ap]m)\\b");
    private static final int INITIAL_YEAR = 1970;
    private static final DateTimeFormatter TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneId().optionalEnd().optionalStart().appendPattern("X").optionalEnd().optionalStart().appendPattern("z").optionalEnd().toFormatter(Locale.US);
    public static final DateTimeFormatter RFC_5322 = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, MailDateParser.dayOfWeek()).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MailDateParser.monthOfYear()).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3).optionalEnd().optionalStart().appendLiteral(' ').appendOffset("+HHMM", "GMT").optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter RFC_5322_LENIENT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendPattern("MMM").appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter RFC_5322_AMPM_LENIENT = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendPattern("MMM").appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_AMPM, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendText(ChronoField.AMPM_OF_DAY).optionalStart().optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_AMPM, ChronoField.AMPM_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter MMM_D_YYYY_HH_MM_AM_PM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("MMM").appendLiteral(' ').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_AMPM, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendText(ChronoField.AMPM_OF_DAY).optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_AMPM, ChronoField.AMPM_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter MMM_D_YYYY_HH_MM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("MMM").appendLiteral(' ').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter MM_SLASH_DD_SLASH_YY_HH_MM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalEnd().optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter MM_SLASH_DD_SLASH_YY_HH_MM_AM_PM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_AMPM, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalEnd().optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().appendLiteral(' ').optionalEnd().appendText(ChronoField.AMPM_OF_DAY).optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_AMPM, ChronoField.AMPM_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NEVER).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().optionalStart().appendLiteral('.').appendValue(ChronoField.MILLI_OF_SECOND, 3, 5, SignStyle.NEVER).optionalEnd().optionalStart().append(TIME_ZONE_FORMATTER).optionalEnd().toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR, ChronoField.HOUR_OF_DAY, ChronoField.MINUTE_OF_HOUR, ChronoField.SECOND_OF_MINUTE, ChronoField.MILLI_OF_SECOND, ChronoField.OFFSET_SECONDS);
    public static final DateTimeFormatter YYYY_MM_DD = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NEVER).toFormatter(Locale.US).withResolverStyle(ResolverStyle.LENIENT).withResolverFields(ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR, ChronoField.YEAR);
    public static final DateTimeFormatter MM_SLASH_DD_SLASH_YYYY = new DateTimeFormatterBuilder().appendPattern("M/d/").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).toFormatter(Locale.US).withZone(DateUtils.MIDDAY.toZoneId());
    public static final DateTimeFormatter DD_SLASH_MM_SLASH_YYYY = new DateTimeFormatterBuilder().appendPattern("d/M/").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).toFormatter(Locale.US).withZone(DateUtils.MIDDAY.toZoneId());
    public static final DateTimeFormatter MMM_DD_YY = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendPattern("MMM").appendLiteral(' ').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).toFormatter(Locale.US);
    public static final DateTimeFormatter DD_MMM_YY = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).appendLiteral(' ').appendPattern("MMM").appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).toFormatter(Locale.US);
    public static final DateTimeFormatter YY_SLASH_MM_SLASH_DD = new DateTimeFormatterBuilder().appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendPattern("/M/d").toFormatter(Locale.US).withZone(DateUtils.MIDDAY.toZoneId());
    private static final DateTimeFormatter[] DATE_FORMATTERS = new DateTimeFormatter[]{DD_MMM_YY, MMM_DD_YY, YYYY_MM_DD, MM_SLASH_DD_SLASH_YYYY, DD_SLASH_MM_SLASH_YYYY, YY_SLASH_MM_SLASH_DD};
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{RFC_5322_LENIENT, RFC_5322_AMPM_LENIENT, MMM_D_YYYY_HH_MM, MMM_D_YYYY_HH_MM_AM_PM, YYYY_MM_DD_HH_MM, MM_SLASH_DD_SLASH_YY_HH_MM, MM_SLASH_DD_SLASH_YY_HH_MM_AM_PM};

    private static Map<Long, String> monthOfYear() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "JAN");
        result.put(2L, "FEB");
        result.put(3L, "MAR");
        result.put(4L, "APR");
        result.put(5L, "MAY");
        result.put(6L, "JUN");
        result.put(7L, "JUL");
        result.put(8L, "AUG");
        result.put(9L, "SEP");
        result.put(10L, "OCT");
        result.put(11L, "NOV");
        result.put(12L, "DEC");
        return result;
    }

    private static Map<Long, String> dayOfWeek() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        result.put(1L, "MON");
        result.put(2L, "TUE");
        result.put(3L, "WED");
        result.put(4L, "THU");
        result.put(5L, "FRI");
        result.put(6L, "SAT");
        result.put(7L, "SUN");
        return result;
    }

    public static Date parseRFC5322(String string) throws ParseException {
        if (string != null) {
            string = string.trim();
            string = string.toUpperCase(Locale.US);
        }
        return Date.from(Instant.from(RFC_5322.parse((CharSequence)string, new ParsePosition(0))));
    }

    public static Date parseDateLenient(String text) {
        if (text == null) {
            return null;
        }
        String normalized = MailDateParser.normalize(text);
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(normalized, dateTimeFormatter);
                return Date.from(Instant.from(zonedDateTime));
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (DateTimeParseException e) {
                try {
                    LocalDateTime localDateTime = LocalDateTime.parse(normalized, dateTimeFormatter);
                    return Date.from(Instant.from(localDateTime.atOffset(ZoneOffset.UTC)));
                }
                catch (SecurityException e2) {
                    throw e2;
                }
                catch (Exception e2) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (DateTimeFormatter dateFormatter : DATE_FORMATTERS) {
            try {
                TemporalAccessor temporalAccessor = dateFormatter.parse(normalized);
                ZonedDateTime localDate = LocalDate.from(temporalAccessor).atStartOfDay().atZone(DateUtils.MIDDAY.toZoneId());
                return Date.from(Instant.from(localDate));
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static boolean hasInstantSeconds(TemporalAccessor temporalAccessor) {
        try {
            temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
            return true;
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    protected static String normalize(String text) {
        text = ((String)text).toUpperCase(Locale.US);
        text = ((String)text).replaceAll(",", "");
        Matcher matcher = OFFSET_PATTERN.matcher((CharSequence)text);
        while (matcher.find()) {
            if (matcher.group(1) == null) continue;
            text = ((String)text).substring(0, matcher.start());
            text = (String)text + matcher.group(1) + StringUtils.leftPad(matcher.group(2), 2, '0') + ":" + matcher.group(3);
            break;
        }
        if ((matcher = LOCALIZED_OFFSET_PATTERN.matcher((CharSequence)text)).find()) {
            text = MailDateParser.buildLocalizedOffset(matcher, (String)text);
        }
        if ((matcher = AM_PM.matcher((CharSequence)text)).find()) {
            text = matcher.replaceFirst("$1 $2");
        }
        if ((matcher = DAYS_OF_WEEK.matcher((CharSequence)text)).find()) {
            text = matcher.replaceAll(" ");
        }
        text = ((String)text).replaceAll("(?i) at ", " ");
        text = ((String)text).replaceAll("\\s+", " ").trim();
        return text;
    }

    private static String buildLocalizedOffset(Matcher matcher, String text) {
        StringBuilder sb = new StringBuilder();
        sb.append(text.substring(0, matcher.start()));
        sb.append(matcher.group(1));
        sb.append(StringUtils.leftPad(matcher.group(2), 2, '0'));
        sb.append(":");
        if (matcher.group(3) != null) {
            sb.append(matcher.group(3));
        } else {
            sb.append("00");
        }
        sb.append(text.substring(matcher.end()));
        return sb.toString();
    }
}

