/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.ComputedTiles;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.internal.Numerics;

final class TileCache
extends Cache<Key, Raster> {
    static final TileCache GLOBAL = new TileCache();

    private TileCache() {
        super(100, Runtime.getRuntime().maxMemory() / 4L, true);
    }

    @Override
    protected int cost(Raster tile) {
        long numBits = Math.multiplyFull(tile.getWidth(), tile.getHeight()) * (long)tile.getNumBands();
        DataBuffer buffer = tile.getDataBuffer();
        if (buffer != null) {
            try {
                numBits *= (long)DataBuffer.getDataTypeSize(buffer.getDataType());
            }
            catch (IllegalArgumentException e) {
                numBits *= 32L;
            }
        }
        return Numerics.clamp(numBits / 8L);
    }

    @Override
    public boolean flush() {
        boolean changed = this.keySet().removeIf(Key::isEmpty);
        return changed |= super.flush();
    }

    static final class Key {
        private final ComputedTiles image;
        private final int tileX;
        private final int tileY;

        Key(ComputedTiles image, int tileX, int tileY) {
            this.image = image;
            this.tileX = tileX;
            this.tileY = tileY;
        }

        final Point indices() {
            return new Point(this.tileX, this.tileY);
        }

        final String error(short key) {
            return Resources.format(key, this.tileX, this.tileY);
        }

        final void dispose() {
            GLOBAL.remove(this);
        }

        final boolean isEmpty() {
            return this.image.get() == null;
        }

        public int hashCode() {
            return System.identityHashCode(this.image) + this.tileX + 65563 * this.tileY;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key k = (Key)obj;
                return this.image == k.image && this.tileX == k.tileX && this.tileY == k.tileY;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.tileX + ", " + this.tileY + "]";
        }
    }
}

