/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.asn1;

import io.churchkey.shade.util.IO;
import io.churchkey.shade.util.Pipe;
import io.churchkey.shade.util.PrintString;
import io.churchkey.util.Pem;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Asn1Dump {
    private Asn1Dump() {
    }

    public static void print(byte[] bytes) throws IOException {
        File der = File.createTempFile("der", ".dump");
        IO.copy(bytes, der);
        ProcessBuilder builder = new ProcessBuilder("openssl", "asn1parse", "-i", "-inform", "DER", "-in", der.getAbsolutePath(), "-dump");
        Process process = builder.start();
        Pipe.pipe(process.getInputStream(), System.out);
        Pipe.pipe(process.getErrorStream(), System.err);
        try {
            int i = process.waitFor();
            if (i != 0) {
                throw new IllegalStateException("Exit code " + i);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String dump(byte[] bytes) throws IOException {
        File der = File.createTempFile("der", ".dump");
        if (bytes[0] == 45 && bytes[1] == 45) {
            Pem pem = Pem.parse(bytes);
            IO.copy(pem.getData(), der);
        } else {
            IO.copy(bytes, der);
        }
        PrintString err = new PrintString();
        PrintString out = new PrintString();
        ProcessBuilder builder = new ProcessBuilder("openssl", "asn1parse", "-i", "-inform", "DER", "-in", der.getAbsolutePath(), "-dump");
        Process process = builder.start();
        Future<Pipe> o = Pipe.pipe(process.getInputStream(), out);
        Future<Pipe> e = Pipe.pipe(process.getErrorStream(), err);
        try {
            int i = process.waitFor();
            o.get();
            e.get();
            if (i != 0) {
                throw new IllegalStateException("Exit code " + i + "\n" + err);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new IllegalStateException(exception);
        }
        finally {
            out.close();
            err.close();
            der.delete();
        }
        return out.toString();
    }
}

