/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.config;

import java.security.Key;
import java.util.Map;
import java.util.function.Supplier;

public class JWTAuthConfiguration {
    public static final String DEFAULT_KEY = "DEFAULT";
    private final Supplier<Map<String, Key>> publicKeys;
    private final Supplier<Map<String, Key>> decryptKeys;
    private final String[] audiences;
    private final String issuer;
    private final int expGracePeriodSecs = 60;
    private final String headerName;
    private final String headerScheme = "Bearer";
    private final boolean allowNoExpiryClaim;
    private final String cookieName;
    private final Integer tokenAge;
    private final Integer clockSkew;
    private String signatureAlgorithm;
    private String decryptAlgorithm;

    public JWTAuthConfiguration(Supplier<Map<String, Key>> publicKeys, String issuer, boolean allowNoExpiryClaim, String[] audiences, Supplier<Map<String, Key>> decryptKeys, String header, String cookie, String decryptAlgorithm, String signatureAlgorithm, Integer tokenAge, Integer clockSkew) {
        this.publicKeys = publicKeys;
        this.decryptKeys = decryptKeys;
        this.issuer = issuer;
        this.allowNoExpiryClaim = allowNoExpiryClaim;
        this.audiences = audiences;
        this.headerName = header;
        this.cookieName = cookie;
        this.decryptAlgorithm = decryptAlgorithm;
        this.signatureAlgorithm = signatureAlgorithm;
        this.tokenAge = tokenAge;
        this.clockSkew = clockSkew;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String[] getAudiences() {
        return this.audiences;
    }

    public Map<String, Key> getPublicKeys() {
        return this.publicKeys.get();
    }

    public Map<String, Key> getDecryptKeys() {
        return this.decryptKeys.get();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public int getExpGracePeriodSecs() {
        return 60;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getHeaderScheme() {
        return "Bearer";
    }

    public boolean isAllowNoExpiryClaim() {
        return this.allowNoExpiryClaim;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public String getDecryptAlgorithm() {
        return this.decryptAlgorithm;
    }

    public Integer getTokenAge() {
        return this.tokenAge;
    }

    public Integer getClockSkew() {
        return this.clockSkew;
    }
}

