/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.jaxrs;

import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tomee.microprofile.jwt.jaxrs.MPJWTSecurityAnnotationsInterceptor;

@Provider
public class MPJWTSecurityAnnotationsInterceptorsFeature
implements DynamicFeature {
    private final ConcurrentMap<Method, Set<String>> rolesAllowed = new ConcurrentHashMap<Method, Set<String>>();
    private final Set<Method> denyAll = new HashSet<Method>();
    private final Set<Method> permitAll = new HashSet<Method>();

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        boolean hasSecurity = this.processSecurityAnnotations(resourceInfo.getResourceClass(), resourceInfo.getResourceMethod());
        if (hasSecurity) {
            context.register((Object)new MPJWTSecurityAnnotationsInterceptor(resourceInfo, this.rolesAllowed, this.denyAll, this.permitAll));
        }
    }

    private boolean processSecurityAnnotations(Class clazz, Method method) {
        Set previous;
        Set<String> roles;
        List<Class<? extends Annotation>[]> classSecurityAnnotations = this.hasClassLevelAnnotations(clazz, RolesAllowed.class, PermitAll.class, DenyAll.class);
        List<Class<? extends Annotation>[]> methodSecurityAnnotations = this.hasMethodLevelAnnotations(method, RolesAllowed.class, PermitAll.class, DenyAll.class);
        if (classSecurityAnnotations.isEmpty() && methodSecurityAnnotations.isEmpty()) {
            return false;
        }
        if (classSecurityAnnotations.size() > 1) {
            throw new IllegalStateException(clazz.getName() + " has more than one security annotation (RolesAllowed, PermitAll, DenyAll).");
        }
        if (methodSecurityAnnotations.size() > 1) {
            throw new IllegalStateException(method.toString() + " has more than one security annotation (RolesAllowed, PermitAll, DenyAll).");
        }
        if (methodSecurityAnnotations.isEmpty()) {
            RolesAllowed classRolesAllowed = clazz.getAnnotation(RolesAllowed.class);
            PermitAll classPermitAll = clazz.getAnnotation(PermitAll.class);
            DenyAll classDenyAll = clazz.getAnnotation(DenyAll.class);
            if (classRolesAllowed != null) {
                roles = new HashSet<String>();
                previous = this.rolesAllowed.putIfAbsent(method, roles);
                if (previous != null) {
                    roles = previous;
                }
                roles.addAll(Arrays.asList(classRolesAllowed.value()));
            }
            if (classPermitAll != null) {
                this.permitAll.add(method);
            }
            if (classDenyAll != null) {
                this.denyAll.add(method);
            }
        }
        RolesAllowed mthdRolesAllowed = method.getAnnotation(RolesAllowed.class);
        PermitAll mthdPermitAll = method.getAnnotation(PermitAll.class);
        DenyAll mthdDenyAll = method.getAnnotation(DenyAll.class);
        if (mthdRolesAllowed != null) {
            roles = new HashSet();
            previous = this.rolesAllowed.putIfAbsent(method, roles);
            if (previous != null) {
                roles = previous;
            }
            roles.addAll(Arrays.asList(mthdRolesAllowed.value()));
        }
        if (mthdPermitAll != null) {
            this.permitAll.add(method);
        }
        if (mthdDenyAll != null) {
            this.denyAll.add(method);
        }
        return true;
    }

    private List<Class<? extends Annotation>[]> hasClassLevelAnnotations(Class clazz, Class<? extends Annotation> ... annotationsToCheck) {
        ArrayList<Class<? extends Annotation>[]> list = new ArrayList<Class<? extends Annotation>[]>();
        for (Class<? extends Annotation> annotationToCheck : annotationsToCheck) {
            if (!clazz.isAnnotationPresent(annotationToCheck)) continue;
            list.add(annotationsToCheck);
        }
        return list;
    }

    private List<Class<? extends Annotation>[]> hasMethodLevelAnnotations(Method method, Class<? extends Annotation> ... annotationsToCheck) {
        ArrayList<Class<? extends Annotation>[]> list = new ArrayList<Class<? extends Annotation>[]>();
        for (Class<? extends Annotation> annotationToCheck : annotationsToCheck) {
            if (!method.isAnnotationPresent(annotationToCheck)) continue;
            list.add(annotationsToCheck);
        }
        return list;
    }
}

