/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.ui;

import java.io.File;
import java.util.HashSet;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.extension.TextRulerController;
import org.apache.uima.ruta.textruler.extension.TextRulerControllerDelegate;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.extension.TextRulerPreprocessor;
import org.apache.uima.ruta.textruler.ui.AddRemoveList;
import org.apache.uima.ruta.textruler.ui.TextRulerResultsView;
import org.apache.uima.ruta.textruler.ui.TextRulerViewComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TextRulerView
extends ViewPart
implements TextRulerControllerDelegate {
    public static final String ID = "org.apache.uima.ruta.ml.MainView";
    private TextRulerViewComposite viewContent;
    private IMemento memento;

    public void errorAlert(String message) {
        MessageBox alert = new MessageBox(this.getSite().getShell(), 33);
        alert.setMessage(message);
        alert.open();
    }

    public boolean yesNoAlert(String message) {
        MessageBox alert = new MessageBox(this.getSite().getShell(), 292);
        alert.setMessage(message);
        int result = alert.open();
        return result == 32;
    }

    public void onStartStopPressed() {
        if (TextRulerController.isRunning()) {
            TextRulerController.abort();
        } else {
            this.startPressed();
        }
        this.updateEnabledStatus();
    }

    public void startPressed() {
        if (!TextRulerController.isRunning()) {
            String[] slotNames;
            String inputDir = this.viewContent.getInputDirectoryPath().trim();
            String additionalDir = this.viewContent.getAdditionalDirectoryPath().trim();
            String preProcTMFile = this.viewContent.getPreprocessorTMFile().trim();
            File inputFile = new File(inputDir);
            if (!inputFile.exists()) {
                AddRemoveList.printErrorDialog("The training data directory was not found!");
                return;
            }
            File additionalFile = new File(additionalDir);
            File preFile = new File(preProcTMFile);
            if (!preFile.exists()) {
                AddRemoveList.printErrorDialog("The preprocessing script was not found!");
                return;
            }
            for (String string : slotNames = this.viewContent.getSlotNames()) {
                System.out.println(string);
            }
            String[] filterArray = this.viewContent.getFilters();
            HashSet<String> filters = new HashSet<String>();
            for (String s : filterArray) {
                filters.add(s);
            }
            if (slotNames.length == 0 || inputDir.length() == 0 || preProcTMFile.length() == 0) {
                this.errorAlert("Please specify at least one slot type, the input directory and the preprocessing file (this is needed even if preprocessing is skipped)!");
                return;
            }
            File dir = new File(inputDir);
            if (!dir.exists() || !dir.isDirectory()) {
                this.errorAlert("The specified input directory could not be found!");
                return;
            }
            Object[] algs = this.viewContent.getAlgListViewer().getCheckedElements();
            for (TextRulerLearnerController controller : TextRulerController.getAvailableControllers()) {
                controller.setEnabled(false);
            }
            for (Object i : algs) {
                TextRulerLearnerController c = (TextRulerLearnerController)i;
                c.setEnabled(true);
                IViewPart resultView = TextRulerView.getView("org.apache.uima.ruta.textruler.TextRulerResultsView", c.getID());
                if (resultView == null) {
                    try {
                        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.apache.uima.ruta.textruler.TextRulerResultsView", ((TextRulerLearnerController)i).getID(), 3);
                        ((TextRulerResultsView)view).setViewTitle(c.getName() + " - Results");
                    }
                    catch (PartInitException e) {
                        TextRulerPlugin.error(e);
                    }
                    continue;
                }
                ((TextRulerResultsView)resultView).setViewTitle(c.getName() + " - Results");
            }
            if (TextRulerController.enabledAlgorithmsCount() > 0) {
                TextRulerController.start(inputDir, additionalDir, preProcTMFile, slotNames, filters, this, this.viewContent.getCurrentAlgorithmParameters(), this.viewContent.getSkipPreprocessing());
            } else {
                this.errorAlert("No algorithm has been activated for learning!");
            }
        }
    }

    public void updateEnabledStatus() {
        boolean isRunning = TextRulerController.isRunning();
        this.viewContent.setEnabled(!isRunning);
    }

    public void asyncUpdateGlobalStatus(final String str) {
        this.viewContent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TextRulerView.this.viewContent.setGlobalStatusString(str);
                TextRulerView.this.updateEnabledStatus();
            }
        });
    }

    public void asyncUpdateList(final TextRulerLearnerController algController, final boolean ruleBaseChanged) {
        this.viewContent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TextRulerView.this.updateList(algController, ruleBaseChanged);
            }
        });
    }

    public void updateList(TextRulerLearnerController algController, boolean ruleBaseChanged) {
        TextRulerResultsView textRulerResultsView;
        this.viewContent.getAlgListViewer().refresh(true, true);
        if (algController != null && ruleBaseChanged && (textRulerResultsView = (TextRulerResultsView)TextRulerView.getView("org.apache.uima.ruta.textruler.TextRulerResultsView", algController.getID())) != null) {
            textRulerResultsView.setResultContents(algController.getCurrentResultString());
        }
    }

    @Override
    public synchronized void algorithmDidEnd(TextRulerLearnerController algController) {
        this.asyncUpdateList(algController, true);
    }

    public static IViewPart getView(String id, String id2) {
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        for (int i = 0; i < viewReferences.length; ++i) {
            if (!id.equals(viewReferences[i].getId()) || !id2.equals(viewReferences[i].getSecondaryId())) continue;
            return viewReferences[i].getView(false);
        }
        return null;
    }

    @Override
    public synchronized void algorithmStatusUpdate(TextRulerLearnerController algController, String statusString, TextRulerLearner.TextRulerLearnerState state, boolean ruleBaseChanged) {
        this.asyncUpdateList(algController, ruleBaseChanged);
    }

    @Override
    public void preprocessorStatusUpdate(TextRulerPreprocessor p, String statusString) {
        this.asyncUpdateGlobalStatus("Preprocessing... " + statusString);
    }

    @Override
    public void globalStatusUpdate(String str) {
        this.asyncUpdateGlobalStatus(str);
    }

    public void createPartControl(Composite parent) {
        this.viewContent = new TextRulerViewComposite(parent, 0, this);
        if (this.memento != null) {
            this.viewContent.restoreState(this.memento);
            this.memento = null;
        }
    }

    public void setFocus() {
        this.viewContent.setFocus();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        this.viewContent.saveState(memento);
    }
}

