/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.crypt;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.pageStore.crypt.ICrypter;

public class DefaultCrypter
implements ICrypter {
    protected Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    @Override
    public SecretKey generateKey(SecureRandom random) {
        try {
            KeyGenerator generator = KeyGenerator.getInstance("AES");
            generator.init(256, random);
            return generator.generateKey();
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] decrypted, SecretKey key, SecureRandom random) {
        try {
            Cipher cipher = this.getCipher();
            cipher.init(1, (Key)key, random);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] ciphertext = cipher.doFinal(decrypted);
            byte[] encrypted = Arrays.copyOf(iv, iv.length + ciphertext.length);
            System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
            return encrypted;
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] encrypted, SecretKey key) {
        try {
            byte[] iv = new byte[16];
            byte[] ciphertext = new byte[encrypted.length - 16];
            System.arraycopy(encrypted, 0, iv, 0, iv.length);
            System.arraycopy(encrypted, 16, ciphertext, 0, ciphertext.length);
            Cipher cipher = this.getCipher();
            cipher.init(2, (Key)key, new IvParameterSpec(iv));
            byte[] decrypted = cipher.doFinal(ciphertext);
            return decrypted;
        }
        catch (GeneralSecurityException ex) {
            throw new WicketRuntimeException(ex);
        }
    }
}

