/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.ContentSecurityPolicySettings;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class FixedCSPValue
implements CSPRenderable {
    private final String value;

    public FixedCSPValue(String value) {
        if (Strings.isEmpty(value)) {
            throw new IllegalArgumentException("CSP directive cannot have empty or null values");
        }
        this.value = value;
    }

    @Override
    public String render(ContentSecurityPolicySettings settings, RequestCycle cycle) {
        return this.value;
    }

    @Override
    public void checkValidityForSrc() {
        String strValue = this.value;
        if ("data:".equals(strValue) || "blob:".equals(strValue) || "mediastream:".equals(strValue) || "filesystem:".equals(strValue) || "https:".equals(strValue)) {
            return;
        }
        if (strValue.startsWith("*.")) {
            strValue = strValue.substring(2);
        }
        try {
            new URI(strValue);
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("Illegal URI for -src directive", urise);
        }
    }

    public String toString() {
        return this.value;
    }
}

