/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;

import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.AddAttributeStrategy;
import org.apache.axiom.ts.dimension.NoNamespaceStrategy;

/**
 * Tests that adding an attribute doesn't add any namespace declarations if the
 * attribute has no namespace.
 */
public class TestAddAttributeWithoutNamespace extends AxiomTestCase {
    private final AddAttributeStrategy addAttributeStrategy;
    private final NoNamespaceStrategy noNamespaceStrategy;
    
    public TestAddAttributeWithoutNamespace(OMMetaFactory metaFactory, AddAttributeStrategy addAttributeStrategy, NoNamespaceStrategy noNamespaceStrategy) {
        super(metaFactory);
        this.addAttributeStrategy = addAttributeStrategy;
        this.noNamespaceStrategy = noNamespaceStrategy;
        addAttributeStrategy.addTestParameters(this);
        noNamespaceStrategy.addTestParameters(this);
    }

    @Override
    protected void runTest() throws Throwable {
        OMFactory factory = metaFactory.getOMFactory();
        OMElement element = factory.createOMElement("test", "urn:test", "");
        // Retrieve the namespace declaration generated by createOMElement
        OMNamespace ns = element.getAllDeclaredNamespaces().next();
        OMAttribute attr = addAttributeStrategy.addAttribute(element, "test", noNamespaceStrategy.createOMNamespace(factory), "test");
        assertNull(attr.getNamespace());
        Iterator<OMNamespace> it = element.getAllDeclaredNamespaces();
        assertTrue(it.hasNext());
        assertEquals(ns, it.next());
        assertFalse(it.hasNext());
    }
}
